﻿using System;
using System.ComponentModel;
using System.Windows.Input;

namespace KoloryWPF.ModelWidoku
{
    using Model;

    public class ModelKoloru : INotifyPropertyChanged
    {
        private Model.Kolor model = Model.DAL.Czytaj();

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if (PropertyChanged != null)
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }

        public byte R
        {
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                OnPropertyChanged("R", "Kolor");
            }
        }

        public byte G
        {
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                OnPropertyChanged("G", "Kolor");
            }
        }

        public byte B
        {
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                OnPropertyChanged("B", "Kolor");
            }
        }

        public void Zapisz()
        {
            model.Zapisz();
        }

        private ICommand zapiszCommand;

        public ICommand ZapiszCommand
        {
            get
            {
                if (zapiszCommand == null)
                    zapiszCommand = new MvvmCommand(argument => { Zapisz(); });
                return zapiszCommand;
            }
        }

        /*
        private ICommand resetujCommand = null;

        public ICommand ResetujCommand
        {
            get
            {
                //leniwa (odroczona) inicjacja
                if(resetujCommand == null) resetujCommand = new ResetujCommand(this);
                return resetujCommand;
            }
        }
        */        

        private void resetuj(object parameter)
        {
            R = 0;
            G = 0;
            B = 0;
        }

        private bool czyResetować(object parameter)
        {
            return R != 0 || G != 0 || B != 0;
        }

        private ICommand resetujCommand = null;

        public ICommand ResetujCommand
        {
            get
            {
                //leniwa (odroczona) inicjacja
                if (resetujCommand == null) resetujCommand = new MvvmCommand(
                    //(object parameter) => { R = 0; G = 0; B = 0; };
                    resetuj, 
                    (object parameter) => { return R != 0 || G != 0 || B != 0; }
                    //czyResetować
                    );
                return resetujCommand;
            }
        }

        public ICommand ZamknijOknoCommand
        {
            get
            {
                return new MvvmCommand(okno => (okno as MainWindow)?.Close());
            }
        }
    }
}
