﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Input;

namespace KoloryWPF.ModelWidoku
{
    public class ResetujCommand : ICommand
    {
        ModelKoloru modelWidoku;

        public ResetujCommand(ModelKoloru modelWidoku)
        {
            this.modelWidoku = modelWidoku;
            if (modelWidoku == null) throw new ArgumentNullException("Ale bez jaj!");
        }

        public event EventHandler CanExecuteChanged
        {
            add
            {
                CommandManager.RequerySuggested += value;
            }
            remove
            {
                CommandManager.RequerySuggested -= value;
            }
        }

        public bool CanExecute(object parameter)
        {
            return modelWidoku.R !=0 || modelWidoku.G != 0 || modelWidoku.B != 0;
        }

        public void Execute(object parameter)
        {                      
            modelWidoku.R = 0;
            modelWidoku.G = 0;
            modelWidoku.B = 0;
        }
    }
}
