﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace KoloryWPF
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();

            panel.Fill = new SolidColorBrush(Colors.Black);
            //Slider_ValueChanged(null, null);

            byte r = Properties.Settings.Default.R;
            byte g = Properties.Settings.Default.G;
            byte b = Properties.Settings.Default.B;
            sliderR.Value = r;
            sliderG.Value = g;
            sliderB.Value = b;
            //KolorPanelu = Color.FromRgb(r, g, b);
        }

        private Color KolorPanelu
        {
            get
            {
                return (panel.Fill as SolidColorBrush).Color;
            }
            set
            {
                (panel.Fill as SolidColorBrush).Color = value;
            }
        }

        private void Slider_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            Color kolor = Color.FromRgb(
                (byte)sliderR.Value, 
                (byte)sliderG.Value, 
                (byte)sliderB.Value);
            //panel.Fill = new SolidColorBrush(kolor);
            //GC.Collect();
            //(panel.Fill as SolidColorBrush).Color = kolor;
            KolorPanelu = kolor;
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            Properties.Settings.Default.R = KolorPanelu.R;
            Properties.Settings.Default.G = KolorPanelu.G;
            Properties.Settings.Default.B = KolorPanelu.B;
            Properties.Settings.Default.Save();
        }
    }
}
