﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
//using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.Reflection;

namespace Notatnik
{
    public partial class Form1 : Form
    {
        private const string tytulOkna = " - Notatnik.NET";
        private string sciezkaPliku = "";
        private bool zmienionyTekst = false;

        private string nazwaPliku
        {
            get
            {
                return System.IO.Path.GetFileName(sciezkaPliku);
            }
        }

        public Form1()
        {
            InitializeComponent();

            saveFileDialog1.Filter = openFileDialog1.Filter;

            kopiujMenuEdycjaDoMenuKontekstowego();
        }

        private void kopiujMenuEdycjaDoMenuKontekstowego()
        {
            //contextMenuStrip1.Items.AddRange(edycjaToolStripMenuItem.DropDownItems);
            for (int i = 0; i < edycjaToolStripMenuItem.DropDownItems.Count - 1; i++)
            {
                ToolStripItem oryginalny = edycjaToolStripMenuItem.DropDownItems[i];
                ToolStripItem nowy = null;
                if (oryginalny is ToolStripMenuItem)
                {
                    nowy = new ToolStripMenuItem(oryginalny.Text, oryginalny.Image);//, new EventHandler(oryginalny.Click));
                }
                if (oryginalny is ToolStripSeparator) nowy = new ToolStripSeparator();
                contextMenuStrip1.Items.Add(nowy);
            }

            //Mozna to zautomatyzowac: http://www.codeproject.com/Questions/72040/how-to-get-method-name-of-control-event-handler
            contextMenuStrip1.Items[0].Click += new EventHandler(cofnijToolStripMenuItem_Click);
            contextMenuStrip1.Items[2].Click += new EventHandler(wytnijToolStripMenuItem_Click);
            contextMenuStrip1.Items[3].Click += new EventHandler(kopiujToolStripMenuItem_Click);
            contextMenuStrip1.Items[4].Click += new EventHandler(wklejToolStripMenuItem_Click);
            contextMenuStrip1.Items[5].Click += new EventHandler(usuńToolStripMenuItem_Click);
            contextMenuStrip1.Items[7].Click += new EventHandler(znajdzToolStripMenuItem_Click);
            contextMenuStrip1.Items[8].Click += new EventHandler(znajdzNastepnyToolStripMenuItem_Click);
            contextMenuStrip1.Items[10].Click += new EventHandler(zaznaczWszystkoToolStripMenuItem_Click);
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private static string[] CzytajPlikTekstowy(string sciezkaDoPliku)
        {
            List<string> linie = new List<string>();
            using (StreamReader sr = new StreamReader(sciezkaDoPliku))
            {
                string linia = "";
                while ((linia = sr.ReadLine()) != null)
                {
                    linie.Add(linia);
                }
            }
            return linie.ToArray();
        }

        private static void ZapiszDoPlikuTekstowego(string sciezkaDoPliku, string[] linie)
        {
            using (StreamWriter sw = new StreamWriter(sciezkaDoPliku))
            {
                foreach (string linia in linie)
                    sw.WriteLine(linia);
            }
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (sciezkaPliku != "") openFileDialog1.FileName = sciezkaPliku;
            else openFileDialog1.InitialDirectory = Directory.GetCurrentDirectory();
            DialogResult dr = openFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                sciezkaPliku = openFileDialog1.FileName;
                textBox1.Lines = CzytajPlikTekstowy(sciezkaPliku);
                textBox1.ClearUndo();                
                this.Text = nazwaPliku + tytulOkna;
                toolStripStatusLabel1.Text = "Tekst wczytany z " + nazwaPliku;
                zmienionyTekst = false;
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            saveFileDialog1.FileName = openFileDialog1.FileName;
            DialogResult dr = saveFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                sciezkaPliku = saveFileDialog1.FileName;
                ZapiszDoPlikuTekstowego(sciezkaPliku, textBox1.Lines);
                textBox1.ClearUndo();                
                this.Text = nazwaPliku + tytulOkna;
                toolStripStatusLabel1.Text = "Tekst zapisany do " + nazwaPliku;
                zmienionyTekst = false;
            }
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (sciezkaPliku == "") zapiszJakoToolStripMenuItem_Click(sender, e);
            else ZapiszDoPlikuTekstowego(sciezkaPliku, textBox1.Lines);
            textBox1.ClearUndo();
            toolStripStatusLabel1.Text = "Tekst zapisany do " + nazwaPliku;
            zmienionyTekst = false;
        }

        private void zawijanieWierszyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zawijanieWierszyToolStripMenuItem.Checked = !zawijanieWierszyToolStripMenuItem.Checked;
            textBox1.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
            toolStripStatusLabel1.Text = "Zawijanie wierszy " + (textBox1.WordWrap ? "włączone" : "wyłączone");
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox1.Font;
            fontDialog1.Color = textBox1.ForeColor;
            if (fontDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.Font = fontDialog1.Font;
                textBox1.ForeColor = fontDialog1.Color;
                toolStripStatusLabel1.Text = "Czcionka zmieniona na " + textBox1.Font.Name + ", rozmiar: " + textBox1.Font.Size.ToString() + ", kolor: " + textBox1.ForeColor.Name;
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox1.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.BackColor = colorDialog1.Color;
            }
            Color kolor = textBox1.BackColor;
            toolStripStatusLabel1.Text = "Kolor tła zmieniony na " + kolor.Name + ", RGB: (" + kolor.R + "," + kolor.G + "," + kolor.B + "), HSB: (" + kolor.GetHue() + "," + kolor.GetSaturation() + "," + kolor.GetBrightness() + ")";
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Undo();
            toolStripStatusLabel1.Text = "Ostatnia zmiana została cofnięta";
        }

        private static string UsunZnakiKoncaLinii(string tekst)
        {
            return tekst.Replace("\n", "").Replace('\r',' ');
        }

        private static string TekstZeSchowkaBezKoncowLinii()
        {
            return UsunZnakiKoncaLinii(Clipboard.GetText());
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //kopiujToolStripMenuItem_Click(kopiujToolStripMenuItem, e);
            //textBox1.SelectedText = "";            
            textBox1.Cut();
            toolStripStatusLabel1.Text = "Fragment tekstu \"" + TekstZeSchowkaBezKoncowLinii() + "\" został przeniesiony do schowka";
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //string fragmentTekstu = textBox1.SelectedText;
            //Clipboard.SetText(fragmentTekstu);            
            textBox1.Copy();
            toolStripStatusLabel1.Text = "Fragment tekstu \"" + TekstZeSchowkaBezKoncowLinii() + "\" został skopiowany do schowka";
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //string fragmentTekstu = Clipboard.GetText();
            //textBox1.SelectedText = fragmentTekstu;            
            textBox1.Paste();
            toolStripStatusLabel1.Text = "Fragment tekstu \"" + TekstZeSchowkaBezKoncowLinii() + "\" został skopiowany ze schowka";
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            toolStripStatusLabel1.Text = "Fragment tekstu \"" + UsunZnakiKoncaLinii(textBox1.SelectedText) + "\" został usunięty";
            textBox1.SelectedText = "";
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
            toolStripStatusLabel1.Text = "Cały tekst został zaznaczony";
        }

        private void godzinaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = DateTime.Now.ToShortTimeString();
            toolStripStatusLabel1.Text = "Wstawiono bieżącą godzinę";
        }

        private void dataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = DateTime.Now.ToShortDateString();
            toolStripStatusLabel1.Text = "Wstawiono bieżącą datę";
        }

        private void dataIGodzinaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            dataToolStripMenuItem_Click(null, null);
            textBox1.SelectedText = " ";
            godzinaToolStripMenuItem_Click(null, null);
            toolStripStatusLabel1.Text = "Wstawiono bieżącą datę i godzinę";
        }

        FindDialog findDialog1 = null;

        private void znajdzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            toolStripButton7.Enabled = true;
            znajdzNastepnyToolStripMenuItem.Enabled = true;

            if(findDialog1==null) findDialog1 = new FindDialog(textBox1);
            findDialog1.Show();
            toolStripStatusLabel1.Text = "Szukanie frazy w tekście";
        }

        private void znajdzNastepnyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (findDialog1 != null)
            {
                int pozycja = findDialog1.ZnajdzNastepny();
                toolStripStatusLabel1.Text = "Następne wystąpienie frazy: " + pozycja.ToString();
            }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            if (!zmienionyTekst)
            {
                this.Text = "* " + this.Text;                
                zmienionyTekst = true;
            }
            toolStripStatusLabel1.Text = "Edycja tekstu";
            cofnijToolStripMenuItem.Enabled = true;
            toolStripButton13.Enabled = true;
        }

        private bool pytanieOZapisanieZmian()
        {            
            if (!zmienionyTekst) return false;            

            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisać zmiany?",
                this.Text,
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question,
                MessageBoxDefaultButton.Button3);

            switch (dr)
            {
                case DialogResult.Yes:
                    zapiszToolStripMenuItem_Click(null,null);
                    return false;
                    //break;
                case DialogResult.No:
                    return false;
                    //break;
                case DialogResult.Cancel:                    
                    return true;
                    //break;
                default:
                    throw new Exception("Nie rozpoznana ewentualność");
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            toolStripStatusLabel1.Text = "Zamykanie aplikacji";
            e.Cancel = pytanieOZapisanieZmian();
            if (e.Cancel) toolStripStatusLabel1.Text = "Zamknięcie aplikacji zostało anulowane";
        }

        private void pasekStanuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pasekStanuToolStripMenuItem.Checked = !pasekStanuToolStripMenuItem.Checked;
            statusStrip1.Visible = pasekStanuToolStripMenuItem.Checked;
            toolStripStatusLabel1.Text = "Pasek stanu jest " + (statusStrip1.Visible ? "widoczny" : "ukryty");
        }

        private void pasekNarzedziToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pasekNarzedziToolStripMenuItem.Checked = !pasekNarzedziToolStripMenuItem.Checked;
            toolStrip1.Visible = pasekNarzedziToolStripMenuItem.Checked;
            toolStripStatusLabel1.Text = "Pasek narzędzi jest " + (toolStrip1.Visible ? "widoczny" : "ukryty");
        }

        private void toolStripComboBox1_TextChanged(object sender, EventArgs e)
        {
            toolStripButton7.Enabled = true;
            znajdzNastepnyToolStripMenuItem.Enabled = true;

            if(findDialog1==null) findDialog1 = new FindDialog(textBox1);
            int pozycja = findDialog1.ZnajdzNastepny(toolStripTextBox1.Text);            
            toolStripStatusLabel1.Text = "Następne wystąpienie frazy: " + pozycja.ToString();
        }

        private void tylkoDoOdczytuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            tylkoDoOdczytuToolStripMenuItem.Checked = !tylkoDoOdczytuToolStripMenuItem.Checked;
            textBox1.ReadOnly = tylkoDoOdczytuToolStripMenuItem.Checked;
            toolStripStatusLabel1.Text = "Tryb " + (textBox1.ReadOnly ? "tylko do odczytu" : "edycji");
        }

        string adresWWW = "http://www.fizyka.umk.pl/~jacek/dydaktyka/net";

        private void stronaWWWToolStripMenuItem_Click(object sender, EventArgs e)
        {
            toolStripStatusLabel1.Text = "WWW: " + adresWWW;
            System.Diagnostics.Process.Start(adresWWW);            
        }

        private void oAutorzeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            toolStripStatusLabel1.Text = "Informacje o programie";
            Assembly a = Assembly.GetExecutingAssembly();
            AssemblyName an = a.GetName();
            object[] aca = a.GetCustomAttributes(typeof(AssemblyCopyrightAttribute), false);
            string copyright = "";
            if (aca.Length > 0 && aca[0] is AssemblyCopyrightAttribute) copyright = (aca[0] as AssemblyCopyrightAttribute).Copyright;
            MessageBox.Show(an.Name + " " + an.Version.ToString() + "\n" + copyright + "\n\nWWW: " + adresWWW, "Notatnik.NET");            
        }

        private void nowyStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!pytanieOZapisanieZmian())
            {
                textBox1.Clear();
                textBox1.ClearUndo();
                sciezkaPliku = "";
                toolStripStatusLabel1.Text = "Nowy dokument tekstowy";
                zmienionyTekst = false;
            }
        }

        #region Drukowanie
        private StringReader sr = null;
        private int licznikStron = 0;

        private void printDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            licznikStron++;
            toolStripStatusLabel1.Text = "Drukowanie, strona: "+licznikStron;

            Font czcionka = textBox1.Font;
            int wysokoscWiersza = (int)czcionka.GetHeight(e.Graphics);
            int iloscLinii = e.MarginBounds.Height / wysokoscWiersza;

            if (sr == null)
            {
                string tekst = "";
                foreach (string wiersz in textBox1.Lines)
                {
                    float szerokosc = e.Graphics.MeasureString(wiersz, czcionka).Width;
                    if (szerokosc < e.MarginBounds.Width)
                    {
                        tekst += wiersz + "\n";
                    }
                    else
                    {
                        float sredniaSzerokoscLitery = szerokosc / wiersz.Length;
                        int ileLiterWWierszu = (int)(e.MarginBounds.Width / sredniaSzerokoscLitery);
                        string skracanyWiersz = wiersz;
                        do
                        {
                            int ostatniaSpacja = skracanyWiersz.Substring(0, ileLiterWWierszu).LastIndexOf(' ');
                            int iloscLiter = ostatniaSpacja != -1 ? Math.Min(ostatniaSpacja, ileLiterWWierszu) : ileLiterWWierszu;
                            tekst += skracanyWiersz.Substring(0, iloscLiter) + "\n";
                            skracanyWiersz = skracanyWiersz.Substring(iloscLiter).TrimStart(' '); //pozostala czesc
                        } while (skracanyWiersz.Length > ileLiterWWierszu);
                        tekst += skracanyWiersz + "\n"; //ostatnia część
                    } //if-else
                } //foreach
                sr = new StringReader(tekst);
            } //if (sr==null)

            e.HasMorePages = true;

            for (int i = 0; i < iloscLinii; i++)
            {
                string wiersz = sr.ReadLine();
                if (wiersz == null)
                {
                    e.HasMorePages = false;
                    sr = null;
                    break;
                }
                e.Graphics.DrawString(wiersz,
                             czcionka,
                             Brushes.Black,
                             e.MarginBounds.Left,                     //x
                             e.MarginBounds.Top + i * wysokoscWiersza);   //y
            }

        }

        private void drukujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (printDialog1.ShowDialog() == DialogResult.OK)
            {
                toolStripStatusLabel1.Text = "Drukowanie";
                licznikStron = 0;
                printDocument1.DocumentName = "Notatnik.NET - " + sciezkaPliku;
                //printDocument1.Print();
                backgroundWorker1.RunWorkerAsync();
            }
        }

        private void ustawieniaStronyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pageSetupDialog1.ShowDialog();
        }

        private void podglądWydrukuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            printPreviewDialog1.ShowDialog();
        }
        #endregion

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {            
            printDocument1.Print();
        }

        private void printDocument1_EndPrint(object sender, System.Drawing.Printing.PrintEventArgs e)
        {
            toolStripStatusLabel1.Text = "Drukowanie zakończone (zadanie wysłane do drukarki)";
        }
    }
}
