﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using KursNET;

namespace UnitTestProject1
{
    [TestClass]
    public class UlamekTests
    {
        private Random r = new Random();

        private int losujLiczbeCalkowita(int? maksymalnaBezwzglednaWartosc = null)
        {
            if (!maksymalnaBezwzglednaWartosc.HasValue)
                return r.Next(int.MinValue, int.MaxValue);
            else
                return r.Next(-maksymalnaBezwzglednaWartosc.Value, maksymalnaBezwzglednaWartosc.Value);
        }

        private int losujLiczbeCalkowitaRoznaOdZera(int? maksymalnaBezwzglednaWartosc = null)
        {
            int wartosc;
            do
            {
                wartosc = losujLiczbeCalkowita(maksymalnaBezwzglednaWartosc);
            }
            while (wartosc == 0);
            return wartosc;
        }

        [TestMethod]
        public void TestKonstruktoraIWłasności()
        {
            //arrange
            int licznik = 1;
            int mianownik = 2;
            
            //act
            Ulamek u = new Ulamek(licznik, mianownik);

            //assert
            Assert.AreEqual(licznik, u.Licznik, "licznik");
            Assert.AreEqual(mianownik, u.Mianownik, "mianownik");
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentException))]
        public void TestKonstruktoraWyjatek()
        {
            //arrange
            int licznik = 1;
            int mianownik = 0;

            //act
            Ulamek u = new Ulamek(licznik, mianownik);
        }

        [TestMethod]
        public void TestSumowania()
        {
            //arrange
            int licznik = 1;
            int mianownik = 3;
            Ulamek u1 = new Ulamek(licznik, mianownik);
            Ulamek u2 = Ulamek.Polowa;

            //act
            Ulamek u = u1 + u2;

            //assert
            Assert.AreEqual(5, u.Licznik, "licznik");
            Assert.AreEqual(6, u.Mianownik, "mianownik");
        }

        [TestMethod]
        public void TestOdejmowania()
        {
            //arrange
            int licznik = 1;
            int mianownik = 3;
            Ulamek u1 = new Ulamek(licznik, mianownik);
            Ulamek u2 = Ulamek.Polowa;

            //act
            Ulamek u = u2 - u1;

            //assert
            Assert.AreEqual(1, u.Licznik, "licznik");
            Assert.AreEqual(6, u.Mianownik, "mianownik");
        }

        [TestMethod]
        public void TestKonstruktora()
        {
            //arrange
            int licznik = 1;
            int mianownik = 2;

            //act
            Ulamek u = new Ulamek(licznik, mianownik);

            //assert
            PrivateObject po = new PrivateObject(u);
            int u_licznik = (int)po.GetField("licznik");
            int u_mianownik = (int)po.GetField("mianownik");
            Assert.AreEqual(licznik, u_licznik, "licznik");
            Assert.AreEqual(mianownik, u_mianownik, "mianownik");
        }

        [TestMethod]
        public void TestMetodyUprosc()
        {
            int licznik = 30;
            int mianownik = -75;

            Ulamek u = new Ulamek(licznik, mianownik);

            Assert.AreEqual(licznik, u.Licznik, "licznik_pre");
            Assert.AreEqual(mianownik, u.Mianownik, "mianownik_pre");

            u.Uprosc();

            Assert.AreEqual(-2, u.Licznik, "licznik_post");
            Assert.AreEqual(5, u.Mianownik, "mianownik_post");
        }        

        [TestMethod]
        public void TestSortowania()
        {
            Ulamek[] tablica = new Ulamek[3];
            for (int i = 0; i < tablica.Length; ++i)
                tablica[i] = new Ulamek(losujLiczbeCalkowita(10), losujLiczbeCalkowitaRoznaOdZera(10));
            for (int i = 0; i < tablica.Length; ++i)
                tablica[i].Uprosc();

            Array.Sort(tablica);

            bool tablicaJestPosortowana = true;
            for (int i = 0; i < tablica.Length - 1; ++i)
                if (tablica[i] > tablica[i + 1])
                {
                    tablicaJestPosortowana = false;
                    break;
                }
            Assert.IsTrue(tablicaJestPosortowana);
        }

        [TestMethod]
        public void TestKonstruktoraIWłasnościLosowe()
        {
            for (int i = 0; i < 10000000; ++i)
            {
                //arrange
                int licznik = losujLiczbeCalkowita();
                int mianownik = losujLiczbeCalkowitaRoznaOdZera();

                //act
                Ulamek u = new Ulamek(licznik, mianownik);

                //assert
                Assert.AreEqual(licznik, u.Licznik, "licznik");
                Assert.AreEqual(mianownik, u.Mianownik, "mianownik");
            }
        }

        [TestMethod]
        public void TestMetodyUproscLosowy()
        {
            for (int i = 0; i < 10000000; ++i)
            {
                int licznik = losujLiczbeCalkowita();
                int mianownik = losujLiczbeCalkowitaRoznaOdZera();

                Ulamek u = new Ulamek(licznik, mianownik);

                Assert.AreEqual(licznik, u.Licznik, "licznik_pre");
                Assert.AreEqual(mianownik, u.Mianownik, "mianownik_pre");

                double wartosc1 = u.ToDouble();

                u.Uprosc();

                double wartosc2 = u.ToDouble();

                Assert.AreEqual(wartosc1, wartosc2);
            }
        }

        [TestMethod]
        public void TestDzielenieLosowanie()
        {
            int zakres = (int)Math.Sqrt(int.MaxValue/2)-1;
            for (int i = 0; i < 10000000; ++i)
            {
                int licznik1 = losujLiczbeCalkowita(zakres);
                int mianownik1 = losujLiczbeCalkowitaRoznaOdZera(zakres);
                int licznik2 = losujLiczbeCalkowitaRoznaOdZera(zakres);
                int mianownik2 = losujLiczbeCalkowitaRoznaOdZera(zakres);

                Ulamek u1 = new Ulamek(licznik1, mianownik1);
                Ulamek u2 = new Ulamek(licznik2, mianownik2);

                Ulamek u = u1 / u2;

                Assert.AreEqual(u1.ToDouble() / u2.ToDouble(), u.ToDouble(), 1E-7);
                Assert.AreEqual(0, u1.ToDouble() / u2.ToDouble() - u.ToDouble(), 1E-7);
            }
        }
    }
}
