﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Kolekcje
{
    enum StanCywilny { Wolny, Związany, Rozwiedziony };

    class Osoba
    {
        public string Imię;
        public string Nazwisko;
        public DateTime DataUrodzenia;
        public StanCywilny StanCywilny;
        public int NumerTelefonu;

        public long WiekWDniach
        {
            get
            {
                return (DateTime.Now - DataUrodzenia).Days;
            }
        }
    }

    class Program
    {
        static void Main1(string[] args)
        {
            List<int> listaLiczbCałkowitych = new List<int>();
            listaLiczbCałkowitych.Add(-1);
            for (int i = 0; i < 10; ++i) listaLiczbCałkowitych.Add(i);

            List<string> listaŁańcuchów = new List<string>();
            listaŁańcuchów.Add("-1");
            for (int i = 0; i < 10; ++i) listaŁańcuchów.Add(i.ToString());

            //-------------

            for (int i = 0; i < listaŁańcuchów.Count; ++i)
                Console.Write(listaLiczbCałkowitych[i].ToString());
            Console.WriteLine();
            for (int i = 0; i < listaŁańcuchów.Count; ++i)
                Console.Write(listaŁańcuchów[i]);
            Console.WriteLine();

            foreach (int element in listaLiczbCałkowitych)
                Console.Write(element.ToString());
            Console.WriteLine();
            foreach (string element in listaŁańcuchów)
                Console.Write(element);
            Console.WriteLine();

            //-------------

            double średnia = 0;
            for (int i = 0; i < listaLiczbCałkowitych.Count; ++i)
            {
                średnia += listaLiczbCałkowitych[i];
            }
            średnia /= listaLiczbCałkowitych.Count;
            Console.WriteLine("Średnia: " + średnia);
            
            Console.WriteLine("Średnia: " + listaLiczbCałkowitych.Average());
            Console.WriteLine("Minimalna: " + listaLiczbCałkowitych.Min());
            Console.WriteLine("Maksymalna: " + listaLiczbCałkowitych.Max());

            Func<int, int> kwadrat = (int i) => {return i*i;};
            Console.WriteLine("Średnia: " + listaLiczbCałkowitych.Average(kwadrat));
            Console.WriteLine("Minimalna: " + listaLiczbCałkowitych.Min(kwadrat));
            Console.WriteLine("Maksymalna: " + listaLiczbCałkowitych.Max(kwadrat));

            Func<string, int> długość = (string s) => { return s.Length; };
            Console.WriteLine("Średnia: " + listaŁańcuchów.Average(długość));
            Console.WriteLine("Minimalna: " + listaŁańcuchów.Min(długość));
            Console.WriteLine("Maksymalna: " + listaŁańcuchów.Max(długość));

            IEnumerable<int> liczbyWiększeOd5 = listaLiczbCałkowitych.Where((int i) => { return i > 5; });
            foreach (int element in liczbyWiększeOd5) Console.Write(element.ToString());
            Console.WriteLine();
            IEnumerable<string> listaPrzekształconych = liczbyWiększeOd5.Select((int i) => { return (i - 5).ToString() + "s"; });
            foreach (string element in listaPrzekształconych) Console.Write(element);
            Console.WriteLine();
            
            IEnumerable<string> kolekcjaKońcowa = listaLiczbCałkowitych
                .Where((int i) => { return i > 5; })
                .Select((int i) => { return (i - 5).ToString() + "s"; });
            foreach (string element in kolekcjaKońcowa) Console.Write(element);
            Console.WriteLine();

            IEnumerable<string> zapytanieLinq = from int i in listaLiczbCałkowitych
                                                where i > 5
                                                select (i - 5).ToString() + "s";
            foreach (string element in zapytanieLinq) Console.Write(element);
            Console.WriteLine();

            int j = 1;
            Rozszerzenia.Show(j);
            j.Show();
            Console.WriteLine();

            Console.WriteLine(listaLiczbCałkowitych.Variance());
            Console.WriteLine(listaLiczbCałkowitych.Variance(kwadrat));
        }

        static void Main(string[] args)
        {
            List<Osoba> listaOsób = new List<Osoba>();
            listaOsób.Add(new Osoba() { Imię = "Jacek", Nazwisko = "Matulewski", DataUrodzenia = new DateTime(1972, 6, 23), StanCywilny = StanCywilny.Związany, NumerTelefonu = 1234567890 });
            listaOsób.Add(new Osoba() { Imię = "Paula", Nazwisko = "Budziejewska", DataUrodzenia = new DateTime(1995, 6, 27), StanCywilny = StanCywilny.Wolny, NumerTelefonu = 987654321 });
            listaOsób.Add(new Osoba() { Imię = "Katarzyna", Nazwisko = "Leonarcik", DataUrodzenia = new DateTime(1995, 10, 8), StanCywilny = StanCywilny.Wolny, NumerTelefonu = 39845638 });

            var listaPersonaliów = from Osoba osoba in listaOsób
                                   select osoba.Imię + " " + osoba.Nazwisko + " (" + (DateTime.Now.Year - osoba.DataUrodzenia.Year).ToString() + ")";
            foreach (string s in listaPersonaliów) Console.WriteLine(s);

            var listaPersonaliówOsóbMłodych = from Osoba osoba in listaOsób
                                              where DateTime.Now.Year - osoba.DataUrodzenia.Year < 35
                                              select osoba.Imię + " " + osoba.Nazwisko + " (" + (DateTime.Now.Year - osoba.DataUrodzenia.Year).ToString() + ")";
            foreach (string s in listaPersonaliówOsóbMłodych) Console.WriteLine(s);

            var listaKobiet = from Osoba osoba in listaOsób
                              where osoba.Imię.EndsWith("a") && !osoba.Imię.Equals("Kuba") && !osoba.Imię.Equals("Barnaba")
                              select osoba.Imię + " " + osoba.Nazwisko + " (" + (DateTime.Now.Year - osoba.DataUrodzenia.Year).ToString() + ")";
            foreach (string s in listaKobiet) Console.WriteLine(s);            
        }
    }

    static class Rozszerzenia
    {
        public static void Show(this object o)
        {
            Console.WriteLine(o.ToString());
        }

        public static double Variance(this IEnumerable<int> c)
        {
            /*
            double średnia = c.Average();
            double suma = 0;
            foreach(int element in c) 
            {
                double d = (element - średnia);
                suma += d * d;                
            }
            return Math.Sqrt(suma / c.Count());
            */
            return Variance(c, (int i) => { return i; });
        }

        public static double Variance(this IEnumerable<int> c, Func<int, int> selector)
        {
            double średnia = c.Average(selector);
            double suma = 0;
            foreach (int element in c)
            {
                double d = (selector(element) - średnia);
                suma += d * d;
            }
            return Math.Sqrt(suma / c.Count());
        }
    }
}
