﻿using System;
using System.Windows.Forms;
using System.IO;
using System.ComponentModel;

namespace FileTextBox
{
    public enum BrowseMode { Default, Custom }

    public partial class FileTextBox : UserControl
    {
        public FileTextBox()
        {
            InitializeComponent();
        }

        #region Properties
        [Category("UMK")]
        [Description("Cud własność")]
        public string FilePath 
        {
            get
            {
                return textBox1.Text;
            }
            set
            {
                textBox1.Text = value;
                OnFilePathChanged();
            }
        }

        [Category("UMK")]
        [Description("Własność UMK")]
        public string Label
        {
            get
            {
                return label1.Text;
            }
            set
            {
                label1.Text = value;
            }
        }

        [Category("UMK")]
        [Description("Kurs .NET")]
        //dla przykładu, reszta w domu
        public string Filter
        {
            get
            {
                return openFileDialog1.Filter;
            }
            set
            {
                openFileDialog1.Filter = value;
            }
        }

        [Category("UMK")]
        [Description("Kurs .NET")]
        public BrowseMode BrowseMode { get; set; }
        #endregion

        private void button1_Click(object sender, EventArgs e)
        {
            FilePath = "";            
        }

        private void button2_Click(object sender, EventArgs e)
        {
            switch (BrowseMode)
            {
                default:
                case BrowseMode.Default:
                    if (!string.IsNullOrWhiteSpace(FilePath))
                    {
                        openFileDialog1.InitialDirectory = Path.GetDirectoryName(FilePath);
                        openFileDialog1.FileName = Path.GetFileName(FilePath);
                    }
                    if (openFileDialog1.ShowDialog() == DialogResult.OK)
                    {
                        FilePath = openFileDialog1.FileName;
                    }
                    break;
                case BrowseMode.Custom:
                    OnBrowseButtonClick();
                    break;
            }
        }

        #region Zdarzenia
        [Category("UMK")]
        [Description("Moje pierwsze zdarzenie")]
        public event EventHandler FilePathChanged;

        private void OnFilePathChanged()
        {
            if (FilePathChanged != null) FilePathChanged(this, EventArgs.Empty);
        }

        public delegate void BrowseEventHandler(object sender, BrowseEventArgs e);
        [Category("UMK")]
        [Description("Moje drugie zdarzenie")]
        public event BrowseEventHandler BrowseButtonClick;

        private void OnBrowseButtonClick()
        {
            BrowseEventArgs e = new BrowseEventArgs(FilePath) { NewFilePath = null };
            if (BrowseButtonClick != null) BrowseButtonClick(this, e);
            if(!e.NewFilePath.Equals(e.OldFilePath)) FilePath = e.NewFilePath;
        }
        #endregion
    }

    public class BrowseEventArgs : EventArgs
    {
        public BrowseEventArgs(string oldFilePath)
        {
            this.OldFilePath = oldFilePath;
        }

        public string OldFilePath { get; private set; }
        public string NewFilePath { get; set; }
        //public bool NewFilePathSelected { get; set; }
    }
}
