﻿using System;
using System.Windows.Forms;
using System.IO;
using System.ComponentModel;

namespace FileTextBox
{
    public partial class FileTextBox : UserControl
    {
        public FileTextBox()
        {
            InitializeComponent();
        }

        #region Properties
        [Category("UMK")]
        [Description("Cud własność")]
        public string FilePath 
        {
            get
            {
                return textBox1.Text;
            }
            set
            {
                textBox1.Text = value;
                OnFilePathChanged();
            }
        }

        [Category("UMK")]
        [Description("Własność UMK")]
        public string Label
        {
            get
            {
                return label1.Text;
            }
            set
            {
                label1.Text = value;
            }
        }

        [Category("UMK")]
        [Description("Kurs .NET")]
        //dla przykładu, reszta w domu
        public string Filter
        {
            get
            {
                return openFileDialog1.Filter;
            }
            set
            {
                openFileDialog1.Filter = value;
            }
        }
        #endregion

        private void button1_Click(object sender, EventArgs e)
        {
            FilePath = "";            
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (!string.IsNullOrWhiteSpace(FilePath))
            {
                openFileDialog1.InitialDirectory = Path.GetDirectoryName(FilePath);
                openFileDialog1.FileName = Path.GetFileName(FilePath);
            }
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                FilePath = openFileDialog1.FileName;
            }
        }

        #region Zdarzenia
        [Category("UMK")]
        [Description("Moje pierwsze zdarzenie")]
        public event EventHandler FilePathChanged;

        private void OnFilePathChanged()
        {
            if (FilePathChanged != null) FilePathChanged(this, EventArgs.Empty);
        }
        #endregion
    }
}
