﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace NotatnikNET
{
    public partial class Form1 : Form
    {
        private class Zakładka
        {
            public bool CzyTekstZmieniony;            
            public TextBox TextBox;

            private TabPage tabPage;
            public TabPage TabPage
            {
                get
                {
                    return tabPage;
                }
                set
                {
                    tabPage = value;
                    if (!string.IsNullOrWhiteSpace(ŚcieżkaPliku)) TabPage.Text = nazwaPliku(ŚcieżkaPliku);
                }
            }

            private static string nazwaPliku(string ścieżkaPliku)
            {
                return Path.GetFileName(ścieżkaPliku);
            }

            private string ścieżkaPliku;
            public string ŚcieżkaPliku
            {
                get
                {
                    return ścieżkaPliku;
                }
                set
                {
                    ścieżkaPliku = value;
                    if (TabPage != null)
                    {
                        if (!string.IsNullOrWhiteSpace(ścieżkaPliku)) TabPage.Text = nazwaPliku(ścieżkaPliku);
                        else TabPage.Text = "Nowa zakładka";
                    }
                }
            }
        }

        private Dictionary<TabPage, Zakładka> zakładki = new Dictionary<TabPage, Zakładka>();

        private Zakładka bieżącaZakładka
        {
            get
            {
                return zakładki[tabControl1.SelectedTab];
            }
        }

        private TextBox bieżącyTextBox
        {
            get
            {
                return bieżącaZakładka.TextBox;
            }
        }

        public Form1()
        {
            InitializeComponent();            

            zakładki.Add(
                tabControl1.TabPages[0],
                new Zakładka()
                {
                    CzyTekstZmieniony = false,
                    ŚcieżkaPliku = "",
                    TextBox = textBox,
                    TabPage = tabControl1.TabPages[0]
                });

            bieżącyTextBox.MouseWheel += TextBox_MouseWheel;
        }

        private void TextBox_MouseWheel(object sender, MouseEventArgs e)
        {
            if (ModifierKeys == Keys.Control)
            {
                const float WHEEL_DELTA = 120f;
                float i = e.Delta / WHEEL_DELTA;
                Font oldFont = bieżącyTextBox.Font;
                float newSize = oldFont.Size + 2 * i;
                if (newSize < 3) newSize = 3;
                Font newFont = new Font(oldFont.FontFamily, newSize, oldFont.Style);
                bieżącyTextBox.Font = newFont;
            }
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult dr = openFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                Zakładka nowaZakładka = twórzNowąZakładkę();
                nowaZakładka.ŚcieżkaPliku = openFileDialog1.FileName;
                toolStripStatusLabel1.Text = "Wczytano plik " + nowaZakładka.ŚcieżkaPliku;
                nowaZakładka.TextBox.Lines = File.ReadAllLines(nowaZakładka.ŚcieżkaPliku);
                nowaZakładka.CzyTekstZmieniony = false;
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult dr = saveFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                zapiszDoPliku(saveFileDialog1.FileName, bieżącyTextBox.Lines);                
            }
        }

        private void zapiszDoPliku(string ścieżkaPliku, string[] linie)
        {
            bieżącaZakładka.ŚcieżkaPliku = ścieżkaPliku;
            File.WriteAllLines(bieżącaZakładka.ŚcieżkaPliku, bieżącaZakładka.TextBox.Lines);
            toolStripStatusLabel1.Text = "Zapisano do pliku " + bieżącaZakładka.ŚcieżkaPliku;
            bieżącaZakładka.CzyTekstZmieniony = false;            
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            bool cancel = false;
            foreach(TabPage tabPage in zakładki.Keys)            
            {                
                cancel &= !pytajOZapisanieDoPliku(zakładki[tabPage]);
            }
            e.Cancel = cancel;
            //e.Cancel = !pytajOZapisanieDoPliku();
        }

        private bool pytajOZapisanieDoPliku(Zakładka zakładka)
        {
            if (!zakładka.CzyTekstZmieniony) return true;

            DialogResult dr = MessageBox.Show(
                "Czy chcesz zapisać zmiany do pliku z zakładki " + zakładka.TabPage.Text + "?", Text,
                MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button3);
            switch (dr)
            {
                case DialogResult.Yes:
                    zapiszJakoToolStripMenuItem_Click(null, EventArgs.Empty);
                    return true;
                case DialogResult.No:
                    return true;
                default:
                case DialogResult.Cancel:
                    return false;
            }
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //if (pytajOZapisanieDoPliku()) textBox.Text = "";
            twórzNowąZakładkę();
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            bieżącaZakładka.CzyTekstZmieniony = true;
            toolStripStatusLabel1.Text = "Liczba znaków: " + bieżącyTextBox.Text.Length.ToString();
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!string.IsNullOrWhiteSpace(bieżącaZakładka.ŚcieżkaPliku)) zapiszDoPliku(bieżącaZakładka.ŚcieżkaPliku, bieżącaZakładka.TextBox.Lines);
            else zapiszJakoToolStripMenuItem_Click(sender, e);
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            bieżącyTextBox.Undo();            
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            bieżącyTextBox.Cut();
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            bieżącyTextBox.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            bieżącyTextBox.Paste();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            bieżącyTextBox.SelectedText = "";
        }

        private void edycjaToolStripMenuItem_DropDownOpened(object sender, EventArgs e)
        {
            cofnijToolStripMenuItem.Enabled = bieżącyTextBox.CanUndo;

            bool czyZaznaczonyTekst = string.IsNullOrEmpty(bieżącyTextBox.SelectedText);
            wytnijToolStripMenuItem.Enabled = !czyZaznaczonyTekst;
            kopiujToolStripMenuItem.Enabled = !czyZaznaczonyTekst;            
            usuńToolStripMenuItem.Enabled = !czyZaznaczonyTekst;
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            bieżącyTextBox.SelectAll();
        }

        private void godzinaDataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DateTime now = DateTime.Now;
            bieżącyTextBox.SelectedText = now.ToShortTimeString() + " " + now.ToShortDateString();
        }

        private void zawijanieWierszyToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            bieżącyTextBox.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = bieżącyTextBox.Font;
            fontDialog1.Color = bieżącyTextBox.ForeColor;
            DialogResult dr = fontDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                bieżącyTextBox.Font = fontDialog1.Font;
                bieżącyTextBox.ForeColor = fontDialog1.Color;
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = bieżącyTextBox.BackColor;
            DialogResult dr = colorDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                bieżącyTextBox.BackColor = colorDialog1.Color;
            }
        }

        private void pasekStanuToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            statusStrip1.Visible = pasekStanuToolStripMenuItem.Checked;
        }

        int indeksZakładki = 0;

        private Zakładka twórzNowąZakładkę()
        {
            indeksZakładki++;
            TabPage newTabPage = new TabPage("< Brak pliku (" + indeksZakładki + ") >");
            TextBox newTextBox = new TextBox();
            newTabPage.Controls.Add(newTextBox);
            newTextBox.Multiline = true;
            newTextBox.AcceptsReturn = true;
            newTextBox.AcceptsTab = true;
            newTextBox.ScrollBars = ScrollBars.Both;
            newTextBox.Dock = DockStyle.Fill;
            newTextBox.TextChanged += textBox1_TextChanged;
            tabControl1.TabPages.Insert(tabControl1.TabCount - 1, newTabPage);
            Zakładka nowaZakładka = new Zakładka()
            {
                CzyTekstZmieniony = false,
                ŚcieżkaPliku = "",
                TextBox = newTextBox,
                TabPage = newTabPage
            };
            zakładki.Add(newTabPage, nowaZakładka);
            tabControl1.SelectedTab = newTabPage;
            return nowaZakładka;
        }

        private void tabControl1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (tabControl1.SelectedIndex == tabControl1.TabCount - 1)
            {
                twórzNowąZakładkę();
            }
            //else toolStripStatusLabel1.Text = "";
            else toolStripStatusLabel1.Text = "Liczba znaków: " + bieżącyTextBox.Text.Length.ToString();
        }        

        private void usunZakladkeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (pytajOZapisanieDoPliku(bieżącaZakładka))
            {
                TabPage usuwanaStrona = bieżącaZakładka.TabPage;
                if (tabControl1.SelectedIndex > 0) tabControl1.SelectedIndex--;
                tabControl1.TabPages.Remove(usuwanaStrona);                
                zakładki.Remove(usuwanaStrona);
            }
        }

        private void ustawieniaStronyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pageSetupDialog1.ShowDialog();
        }

        private void drukujToolStripMenuItem_Click(object sender, EventArgs e)
        {            
            if (printDialog1.ShowDialog() == DialogResult.OK)
            {
                printDocument1.DocumentName = "Notatnik.NET" + bieżącaZakładka.ŚcieżkaPliku;
                backgroundWorker1.RunWorkerAsync();
            }
        }

        private StringReader sr = null; //bufor

        private void printDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            TextBox tb = bieżącyTextBox;            
            Font czcionka = tb.Font;
            int wysokośćWiersza = (int)czcionka.GetHeight(e.Graphics);
            int liczbaLinii = e.MarginBounds.Height / wysokośćWiersza;

            if (sr == null)
            {
                string tekst = "";
                foreach (string wiersz in tb.Lines)
                {
                    float szerokość = e.Graphics.MeasureString(wiersz, czcionka).Width;
                    if (szerokość < e.MarginBounds.Width)
                    {
                        tekst += wiersz + "\n";
                    }
                    else
                    {
                        float średniaSzerokośćLitery = szerokość / wiersz.Length;
                        int liczbaLiterWWierszu = (int)(e.MarginBounds.Width / średniaSzerokośćLitery);
                        /*
                        int ileRazy = wiersz.Length / liczbaLiterWWierszu;
                        for (int i = 0; i < ileRazy; ++i)
                        {
                            tekst += wiersz.Substring(i * liczbaLiterWWierszu, liczbaLiterWWierszu) + "\n";
                        }
                        tekst += wiersz.Substring(ileRazy * liczbaLiterWWierszu) + "\n";
                        */
                        string skracanyWiersz = wiersz;
                        do
                        {
                            int ostatniaSpacja = skracanyWiersz.Substring(0, liczbaLiterWWierszu).LastIndexOf(' ');
                            int liczbaLiter = (ostatniaSpacja != -1) ? ostatniaSpacja : liczbaLiterWWierszu;
                            tekst += skracanyWiersz.Substring(0, liczbaLiter) + "\n";
                            skracanyWiersz = skracanyWiersz.Substring(liczbaLiter).Trim(' ');
                        }
                        while (skracanyWiersz.Length > liczbaLiterWWierszu);
                        tekst += skracanyWiersz + "\n";
                    }
                }
                sr = new StringReader(tekst);
            }
            e.HasMorePages = true;
            for (int i = 0; i < liczbaLinii; i++)
            {
                string wiersz = sr.ReadLine();
                if (wiersz != null) e.Graphics.DrawString(wiersz, czcionka, Brushes.Black, e.MarginBounds.Left, e.MarginBounds.Top + i * wysokośćWiersza);
                else 
                {
                    e.HasMorePages = false;
                    sr = null;
                    break;
                }
            }
        }

        private void toolStripMenuItem7_Click(object sender, EventArgs e)
        {
            printPreviewDialog1.ShowDialog();
        }

        private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            //MessageBox.Show("Drukowanie zakończone");
        }

        delegate void DrukujDelegate();        
        private void drukuj()
        {
            if (this.InvokeRequired)
            {
                DrukujDelegate drukujD = drukuj;
                this.Invoke(drukujD);
            }
            else printDocument1.Print();            
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            drukuj();
        }
    }
}
  