﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Szachownica
{
    public class IndexedButton : Button
    {
        public int IndexX, IndexY;
    }

    public partial class Form1 : Form
    {
        IndexedButton[,] szachownica;

        int nx = 8, ny = 6;

        public Form1()
        {
            InitializeComponent();

            //tworzenie szachownicy
            szachownica = twórzSzachownicę(nx, ny, 10, 10);
            for(int ix = 0; ix < nx; ++ix)
                for(int iy = 0; iy < ny; ++iy)
                    this.Controls.Add(szachownica[ix,iy]);
        }

        private IndexedButton[,] twórzSzachownicę(int nx, int ny, int offsetX, int offsetY)
        {
            IndexedButton[,] szachownica = new IndexedButton[nx, ny];
            for (int iy = 0; iy < ny; iy++)
            {
                int top = offsetY + 80 * iy;                
                for (int ix = 0; ix < nx; ix++)
                {
                    IndexedButton przycisk = new IndexedButton();
                    przycisk.IndexX = ix;
                    przycisk.IndexY = iy;
                    przycisk.Text = (1 + iy * nx + ix).ToString();
                    przycisk.Width = 80;
                    przycisk.Height = 80;
                    przycisk.Top = top;
                    przycisk.Left = offsetX + 80 * ix;                    
                    if ((iy + ix) % 2 == 0)
                    {
                        przycisk.BackColor = Color.White;
                        przycisk.ForeColor = Color.Black;
                    }
                    else
                    {
                        przycisk.BackColor = Color.Black;
                        przycisk.ForeColor = Color.White;
                    }
                    przycisk.Click += przycisk_Click;
                    szachownica[ix, iy] = przycisk;
                }
            }
            return szachownica;
        }

        private void zmieńKolorPrzycisku(int ix, int iy, Color kolor)
        {
            int nx = szachownica.GetLength(0);
            int ny = szachownica.GetLength(1);

            if (ix >= 0 && ix < nx && iy >= 0 && iy < ny)
            {
                szachownica[ix, iy].BackColor = kolor;
            }
        }

        private void przycisk_Click(object sender, EventArgs e)
        {
            IndexedButton ib = sender as IndexedButton;
            ib.Enabled = false;
            int ix = ib.IndexX;
            int iy = ib.IndexY;            
            zmieńKolorPrzycisku(ix, iy, Color.Red);
            zmieńKolorPrzycisku(ix + 1, iy, Color.Green);
            zmieńKolorPrzycisku(ix - 1, iy, Color.Green);
            zmieńKolorPrzycisku(ix, iy + 1, Color.Green);
            zmieńKolorPrzycisku(ix, iy - 1, Color.Green);
        }
    }
}
