﻿using Kolory.Properties;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Kolory
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            trackBar1_ValueChanged(null, EventArgs.Empty);

            Settings s = Settings.Default;
            trackBarR.Value = s.R;
            trackBarG.Value = s.G;
            trackBarB.Value = s.B;
            this.Left = s.X;
            this.Top = s.Y;
            this.Width = s.Szerokość;
            this.Height = s.Wysokość;
        }

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            //panel1.BackColor = Color.Cornsilk;

            panel1.BackColor = Color.FromArgb(
                trackBarR.Value, 
                trackBarG.Value, 
                trackBarB.Value);

            /*
            label1.Text = 
                trackBarR.Value.ToString() + ", " + 
                trackBarG.Value.ToString() + ", " + 
                trackBarB.Value.ToString();
            */
            label1.Text = "#" +
                trackBarR.Value.ToString("X2") + 
                trackBarG.Value.ToString("X2") + 
                trackBarB.Value.ToString("X2");

            label1.ForeColor = (panel1.BackColor.GetBrightness() < 0.6f) ? Color.White : Color.Black;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            Settings s = Settings.Default;
            s.R = (byte)trackBarR.Value;
            s.G = (byte)trackBarG.Value;
            s.B = (byte)trackBarB.Value;
            s.X = this.Left;
            s.Y = this.Top;
            s.Szerokość = this.Width;
            s.Wysokość = this.Height;
            s.Save();
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Escape) Close();
            if (e.Control && e.KeyCode == Keys.C) Clipboard.SetText(label1.Text);
        }
    }
}
