﻿using System.Windows.Media;
using System.ComponentModel;

namespace KoloryWPF.ModelWidoku
{
    public class EdycjaKoloru : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if (PropertyChanged != null)
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }

        private Model.Kolor kolor = Model.Ustawienia.Czytaj();

        public byte R
        {
            get
            {
                return kolor.R;
            }
            set
            {
                kolor.R = value;
                //OnPropertyChanged("R", "Color");
                OnPropertyChanged("R");
            }
        }

        public byte G
        {
            get
            {
                return kolor.G;
            }
            set
            {
                kolor.G = value;
                //OnPropertyChanged("G", "Color");
                OnPropertyChanged("G");
            }
        }

        public byte B
        {
            get
            {
                return kolor.B;
            }
            set
            {
                kolor.B = value;
                //OnPropertyChanged("B", "Color");
                OnPropertyChanged("B");
            }
        }

        /*
        public Color Color
        {
            get
            {
                return kolor.ToColor();
            }
        }
        */

        public void Zapisz()
        {
            Model.Ustawienia.Zapisz(kolor);
        }        
    }

    public static class Rozszerzenia
    {
        public static Color ToColor(this Model.Kolor kolor)
        {
            return new Color() { A = 255, R = kolor.R, G = kolor.G, B = kolor.B };
        }
    }
}
