﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace KoloryWPF
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        Properties.Settings s = Properties.Settings.Default;

        public MainWindow()
        {
            InitializeComponent();

            sliderR.Value = s.R;
            sliderG.Value = s.G;
            sliderB.Value = s.B;
        }

        private void Slider_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            //rectangle.Fill = Brushes.Brown;
            rectangle.Fill = new SolidColorBrush(Color.FromArgb(255, (byte)sliderR.Value, (byte)sliderG.Value, (byte)sliderB.Value));
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            s.R = (byte)sliderR.Value;
            s.G = (byte)sliderG.Value;
            s.B = (byte)sliderB.Value;
            s.Save();
        }
    }
}
