﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace JacekMatulewski.Txt
{
    public class TxtException : Exception
    {
        public TxtException(string message)
            : base(message)
        {
        }
    }

    public interface ITextFile
    {
        string Path {get;}
        string[] Load();
        void Save(string[] lines);
        void AppendLine(string line);
    }

    public class NullTextFile : ITextFile
    {
        private string path;

        public NullTextFile(string path)
        {
            this.path = path;
        }

        public string Path
        {
            get 
            {
                return path;
            }
        }

        public string[] Load()
        {
            return null;
        }

        public void Save(string[] lines)
        {            
        }

        public void AppendLine(string line)
        {            
        }
    }

    public class MemoryTextFile : ITextFile
    {
        private string path;
        private List<string> lines = new List<string>();

        public MemoryTextFile(string path)
        {
            this.path = path;
        }

        public string Path
        {
            get
            {
                return path;
            }
        }

        public string[] Load()
        {
            return this.lines.ToArray();
        }

        public void Save(string[] lines)
        {
            this.lines.Clear();
            this.lines.AddRange(lines);
        }

        public void AppendLine(string line)
        {
            this.lines.Add(line);
        }
    }
}
