﻿using System;
using System.Runtime.InteropServices;
using JacekMatulewski.Csv;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace CsvDocumentUnitTest
{
    [TestClass]
    public class CsvUniformRecordUnitTest
    {
        public CsvUniformRecord<string> TestClass1;
        public CsvUniformRecord<int> TestClass2;

        [TestInitialize]
        public void InitClass()
        {
            TestClass1 = new CsvUniformRecord<string>();
            TestClass2 = new CsvUniformRecord<int>();
        }

        [TestMethod]
        public void ToValuesTest1()
        {
            string[] test = TestClass1.ToValues(null);
            Assert.IsNull(test);
        }

        [TestMethod]
        public void ParseValuesTest1()
        {
            string[] test = {"1", "2", "3", "4"};
            TestClass2.ParseValues(test, null);

            string[] result = TestClass2.ToValues(null);

            for (int i = 0; i < test.Length; i++)
            {
                if(test[i] != result[i]) 
                    Assert.Fail();
            }
        }

        [TestMethod]
        [ExpectedException(typeof(FormatException))]
        public void ParseValuesTest2()
        {
            string[] test = { "aaa1", "bbb2", "ccc3", "ddd4" };
            TestClass2.ParseValues(test, null);
        }
    }
}
