﻿using System;
using JacekMatulewski.Csv;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace CsvDocumentUnitTest
{
    [TestClass]
    public class CsvStringRecordUnitTest
    {
        private CsvStringsRecord TestRecord1;

        [TestInitialize]
        public void CsvStringsRecordTest1()
        {
            TestRecord1 = new CsvStringsRecord();
        }

        [TestMethod]
        [ExpectedException(typeof(Exception))]
        public void ValuesTest1()
        {
            TestRecord1.ToValues(null);
        }

        [TestMethod]
        public void ToValuesTest1()
        {
            string[] test = { "1", "2", "3", "4" };
            TestRecord1.ParseValues(test, null);

            string[] resultStrings = TestRecord1.ToValues(null);

            for (int i = 0; i < test.Length; i++)
            {
                if (test[i] != resultStrings[i])
                    Assert.Fail();
            }
        }

        [TestMethod]
        public void ToStringTest1()
        {
            var testRecord2 = new CsvStringsRecord();
            string[] test = { "1", "2", "3", "4" };
            testRecord2.ParseValues(test, null);

            string resultString = "1 2 3 4 ";
            Assert.AreEqual(resultString, testRecord2.ToString());
        }

        [TestMethod]
        public void CsvStringsRecordTest2()
        {
            var testRecord2 = new CsvStringsRecord("1", "2", "3", "4");

            string resultString = "1 2 3 4 ";
            Assert.AreEqual(resultString, testRecord2.ToString());
        }
    }
}
