﻿using System;
using System.Collections.Generic;
using JacekMatulewski.Csv;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace CsvDocumentUnitTest
{
    [TestClass]
    public class CsvDocumentUnitTest
    {
        public CsvDocumentNet<CsvUniformRecord<string>> TestClass1, TestClass2;
        public CsvDocumentNet<CsvUniformRecord<int>> TestClass3;
        private CsvUniformRecord<string> record1, record2, record3, record4 = null;
        [TestInitialize]
        public void InitMethod()
        {
            TestClass1 = new CsvDocumentNet<CsvUniformRecord<string>>();
            TestClass2 = new CsvDocumentNet<CsvUniformRecord<string>>();
            record1 = new CsvUniformRecord<string>();
            record2 = new CsvUniformRecord<string>(); 
            // Inicialized but not set
            record3 = new CsvUniformRecord<string>();
               
            string[] record1ValueStrings = {"1", "2", "3", "4"};
            record1.ParseValues(record1ValueStrings,null);
            record2.ParseValues(record1ValueStrings, null);
            TestClass2.AddRecord(record1, false);
            TestClass2.AddRecord(record2, false);
        }

        [TestMethod]
        public void CsvDocumentTest1()
        {
            CsvDocument<CsvUniformRecord<string>> x = new CsvDocument<CsvUniformRecord<string>>();
            Assert.IsInstanceOfType(x, typeof(CsvDocument<CsvUniformRecord<string>>));
        }

        [TestMethod]
        public void CountTest1()
        {
            Assert.AreEqual(TestClass1.Count, 0);
        }

        [TestMethod]
        public void CountTest2()
        {
            Assert.AreEqual(TestClass2.Count, 2);
        }

        [TestMethod]
        public void GetElementTest1()
        {
            Assert.AreSame(TestClass2[0], record1);
        }

        [TestMethod]
        [ExpectedException(typeof(NullReferenceException), AllowDerivedTypes = true)]
        public void AddRecordTest1()
        {
            TestClass1.AddRecord(record3, false);
            TestClass1 = new CsvDocumentNet<CsvUniformRecord<string>>();
        }

        [TestMethod]
        [ExpectedException(typeof(NullReferenceException), AllowDerivedTypes = true)]
        public void AddRecordTest2()
        {
            TestClass1.AddRecord(record4, false);
            TestClass1 = new CsvDocumentNet<CsvUniformRecord<string>>();
        }

        [TestMethod]
        public void AddRecordTest3()
        {
            TestClass1.AddRecord(record1, false);
            Assert.AreSame(TestClass1[0], record1);
        }

        [TestMethod]
        public void GetRecordsTest1()
        {
            var records = TestClass2.GetRecords();
            Assert.AreSame(records[0],record1);
            Assert.AreSame(records[1], record2);
        }

        /*
        [TestMethod]
        [ExpectedException(typeof(Exception), AllowDerivedTypes = true)]
        public void SetCommentTest1()
        {
            string test = "Aaaaa";
            TestClass1.AddComment(test);
        }
        */

        [TestMethod]
        [ExpectedException(typeof(Exception), AllowDerivedTypes = true)]
        public void CreateEmptyFileTest1()
        {
            CsvDocumentNet<CsvUniformRecord<string>>.CreateEmptyFile("lik.csv", '#', "zxxx", "asasa");
        }

        [TestMethod]
        [ExpectedException(typeof(NullReferenceException))]
        public void CsvDocumentTest2()
        {
            var x = new CsvDocumentNet<CsvUniformRecord<string>>(new List<CsvUniformRecord<string>>(), null);
        }

        [TestMethod]
        public void SaveAsTest1()
        {
            TestClass2.SaveAs("test.txt", ';');

            var TestClass3 = CsvDocumentNet<CsvUniformRecord<string>>.Load("test.txt", ';');

            var list1 = TestClass2.GetRecords();
            var list2 = TestClass3.GetRecords();

            Assert.AreEqual(TestClass2.Count, TestClass3.Count);

//            Assert.AreEqual(list1[0].ToValues(null), list2[0].ToValues(null));
//            Assert.AreEqual(list1[1].ToValues(null), list2[1].ToValues(null));
        }
    }
}
