﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using JacekMatulewski.Csv;

namespace TestyJednostkowe
{
    [TestClass]
    public class TestyJednostkowe_CsvStringRecord
    {
        CsvStringsRecord element;

        [TestInitialize]
        public void Inicjacja()
        {
            element = new CsvStringsRecord();
        }

        [TestMethod]
        [ExpectedException(typeof(Exception))]
        public void ToValuesTestException()
        {
            element.ToValues(null);
        }

        [TestMethod]
        public void ToValuesTest()
        {
            string[] test = { "1", "2", "3", "4" };
            element.ParseValues(test, null);

            string[] resultStrings = element.ToValues(null);

            for (int i = 0; i < test.Length; i++)
            {
                if (test[i] != resultStrings[i])
                    Assert.Fail();
            }
        }

        [TestMethod]
        public void ToStringTest1()
        {
            var element_02 = new CsvStringsRecord();
            string[] test = { "1", "2", "3", "4" };
            element_02.ParseValues(test, null);

            string resultString = "1 2 3 4 ";
            Assert.AreEqual(resultString, element_02.ToString());
        }

        [TestMethod]
        public void CsvStringsRecordTest2()
        {
            var element_02 = new CsvStringsRecord("1", "2", "3", "4");

            string resultString = "1 2 3 4 ";
            Assert.AreEqual(resultString, element_02.ToString());
        }
    }
}
