﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using JacekMatulewski.Csv;
using System.Collections.Generic;

namespace TestyJednostkowe
{
    class OsobaTest : ICsvRecord
    {
        //private IFormatProvider invariantCultureInfo = CultureInfo.InvariantCulture;

        public string Imię;
        public string Nazwisko;
        public DateTime DataUrodzenia;
        public int NumerTelefonu;

        public void ParseValues(string[] values, CsvRecordParam param)
        {
            Imię = values[0];
            Nazwisko = values[1];
            //DataUrodzenia = DateTime.Parse(values[2], invariantCultureInfo);
            //NumerTelefonu = int.Parse(values[3], invariantCultureInfo);
            DataUrodzenia = DateTime.Parse(values[2]);
            NumerTelefonu = int.Parse(values[3]);
        }

        public string[] ToValues(CsvRecordParam param)
        {
            string[] values = new string[4];
            values[0] = Imię;
            values[1] = Nazwisko;
            //values[2] = DataUrodzenia.ToString(invariantCultureInfo);
            //values[3] = NumerTelefonu.ToString(invariantCultureInfo);
            values[2] = DataUrodzenia.ToString();
            values[3] = NumerTelefonu.ToString();
            return values;
        }

        public override string ToString()
        {
            return Imię + " " + Nazwisko + " (" + Math.Round((DateTime.Today - DataUrodzenia).TotalDays / 365.25).ToString() + ")";
        }
    }

    [TestClass]
    public class TestJednostkowe_CsvDocument
    {
        List<OsobaTest> recordy = new List<OsobaTest>(10);
        CsvDocument<OsobaTest> element;

        [TestInitialize]
        public void Inicjacja()
        {
           element = new CsvDocument<OsobaTest>(recordy);
           //return element;
        }

        //[TestMethod]
        //public void KonstruktorTest()
        //{
        //    Assert.IsNotNull(Konstruktor());
        //}

        [TestMethod]
        public void CountTest()
        {
            //CsvDocument<OsobaTest> element = Konstruktor();

            int oczekiwanyWynik = 10;

            Assert.AreEqual(oczekiwanyWynik, element.Count);
        }

        [TestMethod]
        [ExpectedException(typeof(NullReferenceException))]
        public static void CreateEmptyFileTest()
        {
            //CsvDocument<OsobaTest> element = Konstruktor();
            string filename = null;
            char separator = ';';
            string headerComment = "test1";
            string headerColumnNames = "test1_";

            CsvDocumentNet<OsobaTest> csv = CsvDocumentNet<OsobaTest>.CreateEmptyFile(filename, separator, headerComment, headerColumnNames);
        }

        [TestMethod]
        [ExpectedException(typeof(NullReferenceException))]
        public static void LoadTest()
        {
            //CsvDocument<OsobaTest> element = Konstruktor();
            string filename = null;
            char separator = ';';
            CsvDocumentNet<OsobaTest> csv = CsvDocumentNet<OsobaTest>.Load(filename, separator);
        }

        [TestMethod]
        [ExpectedException(typeof(NullReferenceException))]
        public void AddRecordTest()
        {
            OsobaTest record1 = new OsobaTest();
            element.AddRecord(record1, false);
        }

        /*
        [TestMethod]
        [ExpectedException(typeof(NullReferenceException))]
        public void AddCommentTest()
        {
            string komentarz = null;
            element.AddComment(komentarz);

        }
        */
    }
}
