﻿using System.IO;

namespace JacekMatulewski.Txt
{
    public class TextFile : ITextFile
    {
        string path;

        public TextFile(string path)
        {
            this.path = path;
        }

        public string Path
        {
            get
            {
                if (path == null || string.IsNullOrWhiteSpace(path)) throw new TxtException("Incorrect or no file path specified");
                return path;
            }
        }

        public string[] Load()
        {
            return File.ReadAllLines(path);
        }

        public void Save(string[] lines)
        {
            File.WriteAllLines(path, lines);
        }

        public void AppendLine(string line)
        {
            File.AppendAllText(path, line);
        }
    }
}
