﻿using System.Collections.Generic;

namespace JacekMatulewski.Csv
{
    using TextFile = JacekMatulewski.Txt.TextFile;

    /* Uwaga! Inny model rozwiązania (poprzez ..Helper) jest w pliku CsvAutoRecordDocument.cs */

    public class CsvDocumentNet<T> : CsvDocument<T>
        where T : ICsvRecord, new()
    {        
        private static TextFile getTextFile(string filename)
        {
            if (filename == null) return null;
            else return new TextFile(filename);
        }

        public string Filename
        {
            get
            {
                return textFile.Path;
            }
        }

        public CsvDocumentNet(CsvRecordParam param = null) 
            : base(param)
        {
        }

        //copyData jest na wyrost, bo robi tylko nową listę z tymi samymi referencjami
        //można dla ICloneable: if (record is ICloneable) _record = (T)((ICloneable)record).Clone(); else _record = record;
        public CsvDocumentNet(List<T> records, CsvRecordParam param = null, bool copyData = false) 
            : base(records, param, copyData)
        {            
        }

        protected CsvDocumentNet(string filename, char separatorChar, CsvRecordParam param = null)
            : base(getTextFile(filename), separatorChar, param)
        {
        }

        public static CsvDocumentNet<T> CreateEmptyFile(string filename, char separatorChar, string headerComment, string headerColumnNames, CsvRecordParam param = null)
        {
            //powtarzając kod unikam problemu z tworzeniem instancji klasy bazowej,
            //ale wolałbym wywołac metodę base.CreateEmptyFile(getTextFile(filename), separatorChar, headerComment, headerColumnNames, param);
            CsvDocumentNet<T> csv = new CsvDocumentNet<T>(param);
            csv.textFile = getTextFile(filename);
            csv.SaveAs(csv.textFile, separatorChar, headerComment, headerColumnNames);
            return csv;
        }

        public static CsvDocumentNet<T> Load(string filename, char separatorChar, CsvRecordParam param = null)
        {
            return new CsvDocumentNet<T>(filename, separatorChar, param);
        }

        public void SaveAs(string filename, char separatorChar, string headerComment = null, string headerColumnNames = null)
        {
            base.SaveAs(getTextFile(filename), separatorChar, headerComment, HeaderColumnNames);
        }
    }
}
