﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace JacekMatulewski.Csv
{
    using TextFile = JacekMatulewski.Txt.TextFile;

    public static class CsvAutoRecordDocumentHelper<T>
        where T : new()
    {
        public static TextFile GetTextFile(string filename)
        {
            if (filename == null) return null;
            else return new TextFile(filename);
        }

        public static CsvAutoRecordDocument<T> Load(string filename, char separatorChar, CsvRecordParam param = null)
        {
            return CsvAutoRecordDocument<T>.Load(GetTextFile(filename), separatorChar, param);
        }
    }

    public static class CsvAutoRecordDocumentExtension
    {
        public static void SaveAs<T>(this CsvAutoRecordDocument<T> csv, string filename, char separatorChar, string headerComment = null, string headerColumnNames = null)
            where T : new()
        {
            csv.SaveAs(CsvAutoRecordDocumentHelper<T>.GetTextFile(filename), separatorChar, headerComment, headerColumnNames);
        }
    }
}
