﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using JacekMatulewski.Csv;
using System.Diagnostics;

namespace CSVDocumentDemoNet
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private const string filenameTest = "test.csv";
        private const string filenameOsoby = "osoby.csv";
        private const char separatorChar = ';';

        private void button1_Click(object sender, EventArgs e)
        {
            List<CsvStringsRecord> list = new List<CsvStringsRecord>();
            list.Add(new CsvStringsRecord("Jacek", "Kazimierz", "Matulewski"));
            list.Add(new CsvStringsRecord("Katarzyna", "Matulewska"));
            list.Add(new CsvStringsRecord("Karolina", "Julia", "Matulewska"));
            list.Add(new CsvStringsRecord("Bartek", "Matulewski"));

            try
            {
                CsvDocumentNet<CsvStringsRecord> csv1 = new CsvDocumentNet<CsvStringsRecord>(list);
                csv1.SaveAs(filenameTest, separatorChar, "komentarz", "zbiór łańcuchów o dowolnej liczbie elementów");
            }
            catch(Exception exc)
            {
                MessageBox.Show(exc.Message);
            }

            CsvDocumentNet<CsvStringsRecord> csv2 = CsvDocumentNet<CsvStringsRecord>.Load(filenameTest, separatorChar);
            string s = "";
            foreach(CsvStringsRecord r in csv2)
            {
                s += r.ToString() + '\n';
            }
            MessageBox.Show(s);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            List<CsvUniformRecord<string>> list = new List<CsvUniformRecord<string>>();
            list.Add(new CsvUniformRecord<string>("Jacek", "Kazimierz", "Matulewski"));
            list.Add(new CsvUniformRecord<string>("Katarzyna", "Matulewska"));
            list.Add(new CsvUniformRecord<string>("Karolina", "Julia", "Matulewska"));
            list.Add(new CsvUniformRecord<string>("Bartek", "Matulewski"));

            try
            {
                CsvDocumentNet<CsvUniformRecord<string>> csv1 = new CsvDocumentNet<CsvUniformRecord<string>>(list);
                csv1.SaveAs(filenameTest, separatorChar, "komentarz", "zbiór dowolnej liczby elementów tego samego typu");
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }

            CsvDocumentNet<CsvUniformRecord<string>> csv2 = CsvDocumentNet<CsvUniformRecord<string>>.Load(filenameTest, separatorChar);
            string s = "";
            foreach (CsvUniformRecord<string> r in csv2)
            {
                s += r.ToString() + '\n';
            }
            MessageBox.Show(s);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            List<CsvUniformRecord<int>> list = new List<CsvUniformRecord<int>>();
            list.Add(new CsvUniformRecord<int>(0, 1, 2));
            list.Add(new CsvUniformRecord<int>(3, 4));
            list.Add(new CsvUniformRecord<int>(5, 6, 7));
            list.Add(new CsvUniformRecord<int>(8, 9));

            try
            {
                CsvDocumentNet<CsvUniformRecord<int>> csv1 = new CsvDocumentNet<CsvUniformRecord<int>>(list);
                csv1.SaveAs(filenameTest, separatorChar, "komentarz", "zbiór dowolnej liczby elementów tego samego typu");
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }

            CsvDocumentNet<CsvUniformRecord<int>> csv2 = CsvDocumentNet<CsvUniformRecord<int>>.Load(filenameTest, separatorChar);
            string s = "";
            foreach (CsvUniformRecord<int> r in csv2)
            {
                s += r.ToString() + '\n';
            }
            MessageBox.Show(s);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            List<CsvAutoRecord<Point>> list = new List<CsvAutoRecord<Point>>();
            list.Add(new CsvAutoRecord<Point>(new Point(1, 2)));
            list.Add(new CsvAutoRecord<Point>(new Point(3, 4)));
            list.Add(new CsvAutoRecord<Point>(new Point(5, 6)));
            list.Add(new CsvAutoRecord<Point>(new Point(8, 9)));

            try
            {                
                CsvDocumentNet<CsvAutoRecord<Point>> csv1 = new CsvDocumentNet<CsvAutoRecord<Point>>(list);
                csv1.SaveAs(filenameTest, separatorChar, CsvAutoRecord<Point>.GetColumnTypesLine(separatorChar), CsvAutoRecord<Point>.GetColumnNamesLine(separatorChar));
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }

            CsvDocumentNet<CsvAutoRecord<Point>> csv2 = CsvDocumentNet<CsvAutoRecord<Point>>.Load(filenameTest, separatorChar);
            string s = "";
            foreach (CsvAutoRecord<Point> r in csv2)
            {
                s += r.ToString() + '\n';
            }
            MessageBox.Show(s);
        }

        private void button5_Click(object sender, EventArgs e)
        {
            List<CsvAutoRecord<Rectangle>> list = new List<CsvAutoRecord<Rectangle>>();
            list.Add(new CsvAutoRecord<Rectangle>(new Rectangle(1, 2, 3, 4)));
            list.Add(new CsvAutoRecord<Rectangle>(new Rectangle(5, 6, 7, 8)));
            list.Add(new CsvAutoRecord<Rectangle>(new Rectangle(9, 10, 11, 12)));
            list.Add(new CsvAutoRecord<Rectangle>(new Rectangle(13, 14, 15, 16)));

            try
            {
                CsvDocumentNet<CsvAutoRecord<Rectangle>> csv1 = new CsvDocumentNet<CsvAutoRecord<Rectangle>>(list);
                csv1.SaveAs(filenameTest, separatorChar, CsvAutoRecord<Point>.GetColumnTypesLine(separatorChar), CsvAutoRecord<Point>.GetColumnNamesLine(separatorChar));
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }

            CsvDocumentNet<CsvAutoRecord<Rectangle>> csv2 = CsvDocumentNet<CsvAutoRecord<Rectangle>>.Load(filenameTest, separatorChar);
            string s = "";
            foreach (CsvAutoRecord<Rectangle> r in csv2)
            {
                s += r.ToString() + '\n';
            }
            MessageBox.Show(s);
        }

        private class Punkt
        {
            public int X;
            [CsvWriteToFile(true, ColumnName="Współrzędna Y")] public int Y;
            [CsvWriteToFile(false)] public int Z;

            public int Norm 
            {
                get
                {
                    return X * X + Y * Y + Z * Z;
                }
            }

            public Punkt()
            {
                X = 0;
                Y = 0;
            }

            public Punkt(int x, int y, int z = 0)
            {
                X = x;
                Y = y;
                Z = z;
            }

            public override string ToString()
            {
                return "(" + X.ToString() + "," + Y.ToString() + ")";
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            List<CsvAutoRecord<Punkt>> list = new List<CsvAutoRecord<Punkt>>();
            list.Add(new CsvAutoRecord<Punkt>(new Punkt(1, 2)));
            list.Add(new CsvAutoRecord<Punkt>(new Punkt(3, 4)));
            list.Add(new CsvAutoRecord<Punkt>(new Punkt(5, 6)));
            list.Add(new CsvAutoRecord<Punkt>(new Punkt(8, 9)));

            try
            {                
                CsvDocumentNet<CsvAutoRecord<Punkt>> csv1 = new CsvDocumentNet<CsvAutoRecord<Punkt>>(list);
                csv1.SaveAs(filenameTest, separatorChar, CsvAutoRecord<Punkt>.GetColumnTypesLine(separatorChar), CsvAutoRecord<Punkt>.GetColumnNamesLine(separatorChar));
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }

            CsvDocumentNet<CsvAutoRecord<Punkt>> csv2 = CsvDocumentNet<CsvAutoRecord<Punkt>>.Load(filenameTest, separatorChar);
            string s = "";
            foreach (CsvAutoRecord<Punkt> r in csv2)
            {
                s += r.ToString() + '\n';
            }
            MessageBox.Show(s);
        }

        private void button7_Click(object sender, EventArgs e)
        {
            List<Point> list = new List<Point>();
            list.Add(new Point(1, 2));
            list.Add(new Point(3, 4));
            list.Add(new Point(5, 6));
            list.Add(new Point(8, 9));
            
            var csv = list.ToCsvDocument();            

            string s = "";
            foreach (CsvAutoRecord<Point> r in csv)
            {
                s += r.ToString() + '\n';
            }
            MessageBox.Show(s);
        }

        private void button8_Click(object sender, EventArgs e)
        {
            CsvAutoRecordDocument<OpisBadania> csv = CsvAutoRecordDocumentHelper<OpisBadania>.Load(@"t:\ICNT\TPRD_Edytor\TPRD\bin\Debug\rejestrBadań.csv", separatorChar);

            string s = "";
            foreach (CsvAutoRecord<OpisBadania> r in csv)
            {
                s += r.ToString() + '\n';
            }
            MessageBox.Show(s);

            csv.SaveAs("rejestrBadań-kopia.csv.txt", separatorChar, CsvAutoRecord<OpisBadania>.GetColumnTypesLine(separatorChar), CsvAutoRecord<OpisBadania>.GetColumnNamesLine(separatorChar));
            Process.Start("rejestrBadań-kopia.csv.txt");
        }

        class Osoba //<T>
        {
            public enum PłećType { Mężczyzna, Kobieta }

            public string Imię { get; set; }
            public string Nazwisko;
            public DateTime DataUrodzenia;
            public int NumerTelefonu { get; set; }
            public PłećType Płeć;

            //public int[] NumeryButów; //+1/2
            //public List<int> Cośtam; //+1/2
            //public IEnumerable<T> cośtam2; //+1
            //public T osoba; //zagnieżdżanie //+1

            public Osoba()
            {
                Imię = "";
                Nazwisko = "";
                DataUrodzenia = DateTime.MinValue;
                NumerTelefonu = 0;
                Płeć = PłećType.Mężczyzna;
                //NumeryButów = new int[2] { 0, 0 };
            }

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Math.Round((DateTime.Today - DataUrodzenia).TotalDays / 365.25).ToString() + "), " + Płeć;
            }
        }

        private void button9_Click(object sender, EventArgs e)
        {
            CsvDocumentNet<CsvAutoRecord<Osoba>> csv = new CsvDocumentNet<CsvAutoRecord<Osoba>>();
            Osoba nowaOsoba = new Osoba() { Imię = "Jan", Nazwisko = "Kowalski", DataUrodzenia = DateTime.Today, NumerTelefonu = 1234567890, Płeć = Osoba.PłećType.Mężczyzna/*, NumeryButów = new int[2] { 43, 44 }*/ };
            CsvAutoRecord<Osoba> nowaOsobaCsvAR = new CsvAutoRecord<Osoba>(nowaOsoba);
            csv.AddRecord(nowaOsobaCsvAR, false);
            csv.AddRecord(new CsvAutoRecord<Osoba>(), false);
            csv.AddRecord(nowaOsobaCsvAR, false);
            csv.SaveAs(filenameOsoby, separatorChar, CsvAutoRecord<Osoba>.GetColumnTypesLine(separatorChar), CsvAutoRecord<Osoba>.GetColumnNamesLine(separatorChar));

            //------------
            
            CsvDocumentNet<CsvAutoRecord<Osoba>> csv1 = CsvDocumentNet<CsvAutoRecord<Osoba>>.Load(filenameOsoby, separatorChar);
            string s = "";
            foreach (CsvAutoRecord<Osoba> osoba in csv1)
                s += osoba.GetValues().ToString() + "\n";
            MessageBox.Show(s);            
        }
    }
}
