﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace JacekMatulewski.Csv_KursNet
{
    public class CsvAutoRecord<T> : ICsvRecord
        where T : new()
    {
        private IFormatProvider invariantCultureInfo = CultureInfo.InvariantCulture;

        public static FieldInfo[] getFields()
        {
            //uwzględnić atrybuty !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            FieldInfo[] fields = typeof(T).GetFields(); //tylko publiczne
            Comparison<FieldInfo> fieldComparison = (FieldInfo fieldX, FieldInfo fieldY) => { return fieldX.Name.CompareTo(fieldY.Name); };
            Array.Sort(fields, fieldComparison);
            return fields;
        }

        public static PropertyInfo[] getProperties()
        {
            //uwzględnić atrybuty !!!!!!!!!!!!!!!!!!!!!!!!!!!!!
            PropertyInfo[] properties = typeof(T).GetProperties(); //tylko publiczne
            Comparison<PropertyInfo> propertyComparison = (PropertyInfo propertyX, PropertyInfo propertyY) => { return propertyX.Name.CompareTo(propertyY.Name); };
            Array.Sort(properties, propertyComparison);
            return properties;
        }

        private T values;
        private static FieldInfo[] fields = getFields();
        private static PropertyInfo[] properties = getProperties();

        public CsvAutoRecord()
        {
            this.values = new T();
        }

        public CsvAutoRecord(T values)
        {
            this.values = values;
        }

        public T GetValues()
        {
            return values;
        }

        private static bool isProper(FieldInfo field)
        {
            bool result = !field.IsStatic && !field.IsNotSerialized;
            //atrybuty !!!!!!!!!!!!!!!!!!!!!!!!!!!
            return result;
        }

        private static bool isProper(PropertyInfo property)
        {
            bool result = property.CanWrite;
            //atrybuty !!!!!!!!!!!!!!!!!!!!!!!!!!!
            return result;
        }

        public void ParseValues(string[] strings, CsvRecordParam param)
        {
            values = new T();
            List<string> list = strings.ToList();

            foreach(FieldInfo field in fields)
            {
                if(isProper(field))
                {
                    string s = list.First();
                    object o = null;
                    if (field.FieldType.IsEnum) o = Enum.Parse(field.FieldType, s);
                    else o = Convert.ChangeType(s, field.FieldType, invariantCultureInfo);
                    field.SetValue(values, o);
                    list.RemoveAt(0);
                }
            }

            foreach (PropertyInfo property in properties)
            {
                if (isProper(property))
                {
                    string s = list.First();
                    object o = null;
                    if (property.PropertyType.IsEnum) o = Enum.Parse(property.PropertyType, s);
                    else o = Convert.ChangeType(s, property.PropertyType, invariantCultureInfo);
                    property.SetValue(values, o);
                    list.RemoveAt(0);
                }
            }
        }

        public string[] ToValues(CsvRecordParam param)
        {
            List<string> list = new List<string>();
            if(values!=null)
            {
                foreach (FieldInfo field in fields)
                {
                    if (isProper(field))
                    {
                        //list.Add(field.GetValue(values).ToString());
                        object o = field.GetValue(values);
                        string s = Convert.ToString(o, invariantCultureInfo);
                        list.Add(s);
                    }
                }

                foreach (PropertyInfo property in properties)
                {
                    if (isProper(property))
                    {
                        //list.Add(Property.GetValue(values).ToString());
                        object o = property.GetValue(values);
                        string s = Convert.ToString(o, invariantCultureInfo);
                        list.Add(s);
                    }
                }
                return list.ToArray();
            }
            else
            {
                throw new Exception("No values");
            }
        }

        public static string GetColumnTypesLine(char separator)
        {
            string line = "";

            foreach (FieldInfo field in fields)
            {
                if (isProper(field))
                {
                    line += field.FieldType.Name + separator;
                }
            }

            foreach (PropertyInfo property in properties)
            {
                if (isProper(property))
                {
                    line += property.PropertyType.Name + separator;
                }
            }

            return line;
        }

        public static string GetColumnNamesLine(char separator)
        {
            string line = "";

            foreach (FieldInfo field in fields)
            {
                if (isProper(field))
                {
                    line += field.Name + separator;
                }
            }

            foreach (PropertyInfo property in properties)
            {
                if (isProper(property))
                {
                    line += property.Name + separator;
                }
            }

            return line;
        }

        public override string ToString()
        {
            return values.ToString();
        }
    }
}
