﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using JacekMatulewski.Csv_KursNet;
using System.Globalization;

namespace CsvDocumentDemo
{
    public partial class Form1 : Form
    {
        private const char separatorChar = ';';

        public Form1()
        {
            InitializeComponent();
        }

        //struct Osoba : ICsvRecord
        class Osoba : ICsvRecord
        {
            //private IFormatProvider invariantCultureInfo = CultureInfo.InvariantCulture;

            public string Imię;
            public string Nazwisko;
            public DateTime DataUrodzenia;
            public int NumerTelefonu;

            public void ParseValues(string[] values, CsvRecordParam param)
            {
                Imię = values[0];
                Nazwisko = values[1];
                //DataUrodzenia = DateTime.Parse(values[2], invariantCultureInfo);
                //NumerTelefonu = int.Parse(values[3], invariantCultureInfo);
                DataUrodzenia = DateTime.Parse(values[2]);
                NumerTelefonu = int.Parse(values[3]);
            }

            public string[] ToValues(CsvRecordParam param)
            {
                string[] values = new string[4];
                values[0] = Imię;
                values[1] = Nazwisko;
                //values[2] = DataUrodzenia.ToString(invariantCultureInfo);
                //values[3] = NumerTelefonu.ToString(invariantCultureInfo);
                values[2] = DataUrodzenia.ToString();
                values[3] = NumerTelefonu.ToString();
                return values;
            }

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Math.Round((DateTime.Today - DataUrodzenia).TotalDays/365.25).ToString() + ")";
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //CsvDocument<Osoba> osoby = new CsvDocument<Osoba>();         

            CsvDocument<Osoba> csv = CsvDocument<Osoba>.CreateEmptyFile("osoby.csv", separatorChar, "", "Imię;Nazwisko;DataUrodzenia;NumerTelefonu");
            csv.AddRecord(new Osoba() { Imię = "Jan", Nazwisko = "Kowalski", DataUrodzenia = DateTime.Today, NumerTelefonu = 1234567890 });
            csv.Save();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            CsvDocument<Osoba> csv = CsvDocument<Osoba>.Load("osoby.csv", separatorChar);
            string s = "";
            /*
            for (int i = 0; i < csv.Count; ++i)
            {
                s += csv[i].ToString() + "\n";
            }
            */
            foreach(Osoba osoba in csv)
            {
                s += osoba.ToString() + "\n";
            }
            MessageBox.Show(s);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            try
            {
                CsvDocument<Osoba> csv = CsvDocument<Osoba>.Load("osoby.csv", separatorChar);

                Osoba nowaOsoba = new Osoba() 
                { 
                    Imię = tbImię.Text, 
                    Nazwisko = tbNazwisko.Text, 
                    DataUrodzenia = mcDataUrodzin.SelectionStart, 
                    NumerTelefonu = int.Parse(tbNumerTelefonu.Text) 
                };
                csv.AddRecord(nowaOsoba, true);
            }
            catch(Exception exc)
            {
                MessageBox.Show(exc.Message, Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            CsvDocument<CsvStringsRecord> csv = CsvDocument<CsvStringsRecord>.CreateEmptyFile("osoby1.csv", separatorChar, "", "Imię;Nazwisko;DataUrodzenia;NumerTelefonu");
            csv.AddRecord(new CsvStringsRecord("Jan", "Kowalski", "08/13/2013 00:00:00", "1234567890"), false);
            csv.SaveAs("osoba_string.csv", separatorChar);

            csv = CsvDocument<CsvStringsRecord>.Load("osoby.csv", separatorChar);
            string s = "";
            foreach (CsvStringsRecord record in csv)
            {
                s += record.ToString() + "\n";
            }
            MessageBox.Show(s);
        }
    }
}
