﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using JacekMatulewski.Csv_KursNet;
using System.Globalization;

namespace CsvDocumentDemo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        class Osoba : ICsvRecord
        {
            private IFormatProvider invariantCultureInfo = CultureInfo.InvariantCulture;

            public string Imię;
            public string Nazwisko;
            public DateTime DataUrodzenia;
            public int NumerTelefonu;

            public void ParseValues(string[] values, CsvRecordParam param)
            {
                Imię = values[0];
                Nazwisko = values[1];
                DataUrodzenia = DateTime.Parse(values[2], invariantCultureInfo);
                NumerTelefonu = int.Parse(values[3], invariantCultureInfo);
            }

            public string[] ToValues(CsvRecordParam param)
            {
                string[] values = new string[4];
                values[0] = Imię;
                values[1] = Nazwisko;
                values[2] = DataUrodzenia.ToString(invariantCultureInfo);
                values[3] = NumerTelefonu.ToString(invariantCultureInfo);
                return values;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //CsvDocument<Osoba> osoby = new CsvDocument<Osoba>();         

            CsvDocument<Osoba> csv = CsvDocument<Osoba>.CreateEmptyFile("osoby.csv", ';', "", "Imię;Nazwisko;DataUrodzenia;NumerTelefonu");
            csv.AddRecord(new Osoba() { Imię = "Jan", Nazwisko = "Kowalski", DataUrodzenia = DateTime.Today, NumerTelefonu = 1234567890 });
            csv.Save();
        }
    }
}
