﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

//using WMPLib;

namespace Choinka
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            Left = Properties.Settings.Default.X;
            Top = Properties.Settings.Default.Y;

            WMPLib.WindowsMediaPlayer wmp = new WMPLib.WindowsMediaPlayer();
            wmp.URL = "Ring05.wav";
            wmp.controls.play();
            wmp.settings.setMode("loop", true);


            this.SetStyle(ControlStyles.DoubleBuffer, true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
            this.SetStyle(ControlStyles.UserPaint, true);
        }

        private Image obraz = null;
        private Image gwiazda = null;

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            if (obraz == null) obraz = Bitmap.FromFile("Choinka2.png");
            e.Graphics.DrawImage(obraz, 0, 0, obraz.Width/2, obraz.Height/2);

            int sekundy = DateTime.Now.Second;
            if (gwiazda == null) gwiazda = Bitmap.FromFile("christmas_star.png");
            e.Graphics.DrawImage(gwiazda, (float)(100*(1+Math.Sin(0.1*x))), 0, gwiazda.Width / 10, gwiazda.Height / 10);            
        }

        private bool przenoszenie = false;
        private int x0, y0;

        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            if(e.Button == MouseButtons.Left)
            {
                przenoszenie = true;
                x0 = e.X;
                y0 = e.Y;
                Cursor = Cursors.Hand;
            }
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            if(przenoszenie)
            {                
                int dx = e.X - x0;
                int dy = e.Y - y0;
                Left += dx;
                Top += dy;
            }
        }

        private void Form1_MouseUp(object sender, MouseEventArgs e)
        {
            Cursor = Cursors.Default;
            przenoszenie = false;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            Properties.Settings.Default.X = Left;
            Properties.Settings.Default.Y = Top;
            Properties.Settings.Default.Save();
        }

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            notifyIcon1.ShowBalloonTip(1000);                                                            
        }

        private void zamknijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void stronaWFAiISToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Process.Start("http://www.fizyka.umk.pl/");
        }

        private void oToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Kurs .NET analizuje kody przez Święta!!!");
        }

        int x = 0;

        private void timer1_Tick(object sender, EventArgs e)
        {
            x += 1;
            Refresh();
        }
    }
}
