﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AsystentZakupów.Models
{
    public class Autosumowanie
    {
        public decimal Suma { get; private set; }
        public decimal Limit { get; private set; }

        public Autosumowanie(decimal limit, decimal suma=0)
        {
            this.Suma = suma;
            this.Limit = limit;
        }

        public bool CzyMoznaDodacKwote(decimal kwota)
        {
            return Suma + kwota <= Limit && kwota >= 0;
        }

        public void DodajKwote(decimal kwota)
        {
            if (CzyMoznaDodacKwote(kwota))
                Suma += kwota;
            else
                throw new Exception("Kwota jest zbyt duża");
        }
    }
}
