﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Microsoft.Practices.Prism.Modularity;
using Microsoft.Practices.Prism.Regions;
using Microsoft.Practices.Unity;

namespace ModuleA
{
    public class ModuleA : IModule
    {
        protected IUnityContainer Container { get; private set; }
        protected IRegionManager RegionManager { get; private set; }        

        public ModuleA(IRegionManager regionManager, IUnityContainer container)
        {
            Container = container;
            RegionManager = regionManager;
        }

        public void Initialize()
        {            
            //RegionManager.RegisterViewWithRegion("MainRegion", typeof(ModuleAView));

            Container.RegisterType<object, ModuleAView>(typeof(ModuleAView).Name);
            RegionManager.RegisterViewWithRegion("MenuRegionA", typeof(ButtonViewA));
        }
    }
}
