﻿using System;

namespace AsystentZakupówWPF.Model
{
    public class SumowanieKwot
    {
        public decimal Limit { get; private set; } = 1000;
        public decimal Suma { get; private set; } = 0;

        public SumowanieKwot(decimal limit, decimal suma = 0)
        {
            this.Limit = limit;
            this.Suma = suma;
        }

        public void Dodaj(decimal kwota)
        {
            if (!CzyKwotaJestPoprawna(kwota))
                throw new ArgumentOutOfRangeException("Kwota prowadzi do przekroczenia limitu lub jest ujemna");
            Suma += kwota;
        }

        public bool CzyKwotaJestPoprawna(decimal kwota)
        {
            bool czyDodatnia = kwota > 0;
            bool czyPrzekroczyLimit = Suma + kwota > Limit;
            return czyDodatnia && !czyPrzekroczyLimit;
        }
    }
}
