﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using PESELValidator.Model;
using System.Windows.Input;
using System.Windows.Controls;
using System.Reflection;

namespace PESELValidator.ViewModel
{
	class PeselViewVievModel : INotifyPropertyChanged
	{
		PESEL pesel = new PESEL();
		string errorInfo = "";

		public PeselViewVievModel()
		{
			pesel.ModelError += ShowErrorInfo;

			resetViewCmd = new RelayCommand( ResetView, arg => { return true; } );
			checkPeselCmd = new RelayCommand( CheckPesel, CanCheckPesel );
			swapProgCmd = new RelayCommand( SwapProg, arg => { return CanSwapProg( arg ); } );
		}

		ICommand resetViewCmd;
		public ICommand ResetViewCommand
		{ get { return resetViewCmd; } }


		ICommand checkPeselCmd;
		public ICommand CheckPeselCommand
		{ get { return checkPeselCmd; } }

		private void CheckPesel( object arg )
		{
			string peselStr = arg as string;

			try
			{
				ErrorInfo = "";
				pesel = new PESEL( peselStr, ShowErrorInfo );
				OnPropertyChanged( "Year", "Month", "Day", "Series", "Sex" );
			}
			catch (Exception ex)
			{ ErrorInfo = ex.Message; }
		}

		private bool CanCheckPesel( object arg )
		{
			string s = arg as string;
			if ( s == null ) return false;

			return s.Length == 11 && s.All( c => c >= '0' && c <= '9' );
		}

		/// <summary>TODO: Zmiana trybu sprawdzania na tryb generowania numeru PESEL</summary>
		ICommand swapProgCmd;
		public ICommand SwapProgCommand
		{ get { return swapProgCmd; } }

		private void SwapProg( object arg )
		{
			throw new NotImplementedException( "SwapProg" );
		}

		private bool CanSwapProg( object arg )
		{
			return false;
		}

		public string Year
		{
			get { return pesel.Year.ToString(); }
			set { pesel.Year = int.Parse( value ); OnPropertyChanged( "Year", "Month" ); }
		}

		public string Month
		{
			get { return Enum.GetName(typeof(Miesiąc), pesel.Month); }
			set { pesel.Month = int.Parse( value ); OnPropertyChanged( "Year", "Month" ); }
		}

		public string Day
		{
			get { return pesel.Day.ToString(); }
			set { pesel.Day = int.Parse( value ); OnPropertyChanged( "Day" ); }
		}

		public string Series
		{ get { return pesel.SeriesNr.ToString(); } }

		public string Sex
		{ get { return pesel.Sex.ToString(); } }

		public string ErrorInfo
		{
			get { return errorInfo;  }
			private set {
				errorInfo = value.Length != 0 ? "Błąd: " + value : value;
				OnPropertyChanged( "ErrorInfo" );
			}
		}

		private void ShowErrorInfo( string msg )
		{
			ErrorInfo = msg;
		}

	private void ResetView( object arg )
		{
			PeselValidatorView v = arg as PeselValidatorView;

			v.tbPESEL.Text = "DDMMRRSSSPC";
			v.tbDay.Text = v.tbMonth.Text = v.tbSeries.Text = v.tbSex.Text = v.tbYear.Text = "";
			v.lblErrorInfo.Content = "";
		}


		public event PropertyChangedEventHandler PropertyChanged;

		private void OnPropertyChanged(params string[] properties)
		{
			foreach ( string prop in properties )
				PropertyChanged( this, new PropertyChangedEventArgs( prop ) );
		}
	}//PeselViewViewModel
}
