﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

using MultipTabForKids.Model;
using MultipTabForKids.View;

namespace MultipTabForKids.ViewModel
{
	/// <summary>Widok pytania z polem tekstowym na odpowiedź</summary>
	public class TextQuestionViewModel : TextModeQuestion, INotifyPropertyChanged, ICheckAnswer
	{
		private static Style styleOK = App.Current.FindResource( ControlStyle.OK ) as Style;
		private static Style styleError = App.Current.FindResource( ControlStyle.Error ) as Style;

		public static readonly DataTemplate QuestionTemplate = App.Current.FindResource( DataTemplates.TextModeTemplate ) as DataTemplate;

		private static int tabIndex = 1;

		public static int TabIndex { get { return tabIndex++; } set { tabIndex = value; } }

		public TextQuestionViewModel( int qNr, MulTabQuestion q ) : base(qNr, q)
		{
		}

		public Style StyleCheckedAnswer
		{
			get;
			set;
		}

		public bool CheckAnswer()
		{
			bool result = GoodAnswer == Answer;
			StyleCheckedAnswer = result == true ? styleOK : styleError;
			if ( PropertyChanged != null )
				PropertyChanged( this, new PropertyChangedEventArgs( "StyleCheckedAnswer" ) );
			return result;
		}

		public bool IsAnswered
		{ get { return Answer != string.Empty; } }

		public event PropertyChangedEventHandler PropertyChanged;
	}
}
