﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel;
using MultipTabForKids.Model;
using System.Windows;

using MultipTabForKids.View;

namespace MultipTabForKids.ViewModel
{
	/// <summary>Widok pytania z opcjami ABC
	/// Text z pytanie i RadioButton z opcjami do wyboru</summary>
	public class ABCQuestionViewModel : INotifyPropertyChanged, ICheckAnswer
	{
		private static Style styleOK = App.Current.FindResource( ControlStyle.OK ) as Style;
		private static Style styleError = App.Current.FindResource( ControlStyle.Error ) as Style;
		private static Style styleNormal = App.Current.FindResource( ControlStyle.Normal ) as Style;

		/// <summary>Domyślny szablon danych dla pytania</summary>
		public static readonly DataTemplate QuestionTemplate = App.Current.FindResource( DataTemplates.ABCModeTemplate ) as DataTemplate;

		/// <summary>Model pytania</summary>
		private ABCModeQuestion qModel;
		/// <summary>Opcja zaznaczona przez użytkownika</summary>
		private Answer checkedAnswer = Answer.None;
		/// <summary>Opcja prawidłowej odpowiedzi</summary>
		private Answer goodAnswer
		{
			get
			{
				if ( qModel.GoodAnswer == qModel.AnswerA )
					return Answer.A;
				else if ( qModel.GoodAnswer == qModel.AnswerB )
					return Answer.B;
				else if ( qModel.GoodAnswer == qModel.AnswerC )
					return Answer.C;
				else
					return Answer.None;
			}
		}

		public Style StyleA { get; set; }
		public Style StyleB { get; set; }
		public Style StyleC { get; set; }

		public ABCQuestionViewModel( int qNr, MulTabQuestion q )
		{
			qModel = new ABCModeQuestion( qNr, q );
		}

		public int QuestionNr { get { return qModel.QuestionNr; } }
		public string Question { get { return (qModel.QuestionNr+1) + ". " + qModel.Question; } }

		public string AnswerA { get { return "A) " + qModel.AnswerA; } }
		public bool CheckA {
			get { return checkedAnswer == Answer.A; }
			set
			{
				checkedAnswer = Answer.A;
				qModel.UserAnswer = qModel.AnswerA;
				OnPropertyChanged( "CheckA", "CheckB", "CheckC" );
			}
		}

		public string AnswerB { get { return "B) " + qModel.AnswerB; } }
		public bool CheckB {
			get { return checkedAnswer == Answer.B; }
			set
			{
				checkedAnswer = Answer.B;
				qModel.UserAnswer = qModel.AnswerB;
				OnPropertyChanged( "CheckA", "CheckB", "CheckC" );
			}
		}

		public string AnswerC { get { return "C) " + qModel.AnswerC; } }
		public bool CheckC {
			get { return checkedAnswer == Answer.C; }
			set
			{
				checkedAnswer = Answer.C;
				qModel.UserAnswer = qModel.AnswerC;
				OnPropertyChanged( "CheckA","CheckB","CheckC" );
            }
		}

		public bool CheckAnswer()
		{
			bool result =  qModel.CheckUserAnswer();
			StyleA = goodAnswer == Answer.A ? styleOK : styleError;
			StyleB = goodAnswer == Answer.B ? styleOK : styleError;
			StyleC = goodAnswer == Answer.C ? styleOK : styleError;

			OnPropertyChanged( "StyleA", "StyleB", "StyleC" );
			return result;
		}

		public bool IsAnswered
		{ get { return checkedAnswer != Answer.None; } }

		public ABCModeQuestion Model
		{ get { return qModel; } }

		public event PropertyChangedEventHandler PropertyChanged;
		private void OnPropertyChanged( params string[] properties )
		{
			foreach ( string prop in properties )
				PropertyChanged( this, new PropertyChangedEventArgs( prop ) );
		}
	}
}
