﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MultipTabForKids.Model
{
	/// <summary>Klasa pytania do użycia przez ABC i TextModeQuestion</summary>
	public class MulTabQuestion
	{
		static Random r = new Random( DateTime.Now.Millisecond );
		static StringBuilder sb = new StringBuilder();

		/// <summary>Wygenerowane czynniki pytania</summary>
		public readonly int[] FactorValues;

		static int RandSign(double minusProbability)
		{
			return r.NextDouble() <= minusProbability ? -1 : 1;
		}

		public MulTabQuestion(int factorCount, int min = 0, int max = 11, double minusProbability = 0.4)
		{
			FactorValues = new int[factorCount];

			for ( int i = 0 ;i < FactorValues.Length ;i++ )
				FactorValues[i] = r.Next( min, max ) * RandSign(minusProbability);
		}

		/// <summary> Czynniki wyniku w formie pytania </summary>
		public string Question
		{
			get
			{
				for ( int i = 0 ;i < FactorValues.Length ;i++ )
					sb.Append(i == 0 ? FactorValues[i].ToString() : " x " + FactorValues[i].ToString() );

				string result = sb.ToString();
				sb.Clear();
				return result;
			}
		}

		/// <summary>Poprawna odpowiedź</summary>a
		public int Answer
		{
			get
			{
				int ans = 1;
				for (int i = 0 ; i < FactorValues.Length ; i++ )
						ans *= FactorValues[i];
				return ans;
			}
		}

		/// <summary>Prawdopodobna odpowiedź</summary>
		public int LikelyAnswer()
		{
			return (int)((Answer == 0 ? r.Next(0, 50) : Answer) * ( r.NextDouble() * 2 ));
		}
	}

	/// <summary>Statyczna klasa generujące listę pytań</summary>
	public static class MulTabGenerator
	{
		public static List<MulTabQuestion> GenerateList(int questionCount, int factorCount)
		{
			List<MulTabQuestion> list = new List<MulTabQuestion>( questionCount );

			for ( int i = 0 ;i < questionCount ;i++ )
				list.Add( new MulTabQuestion( factorCount ) );

			return list;
		}

		public static MulTabQuestion[] GenerateTab(int questionCount, int factorCount)
		{
			MulTabQuestion[] tab = new MulTabQuestion[questionCount];

			for ( int i = 0 ;i < tab.Length ;i++ )
				tab[i] = new MulTabQuestion( factorCount );

			return tab;
		}

		public static MulTabQuestion Generate(int factorCount = 2)
		{
			return new MulTabQuestion( factorCount );
		}
	}
}
