﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MultipTabForKids.Model
{
	/// <summary>Model pytania z opcjami odpowiedzi ABC</summary>
	public class ABCModeQuestion
	{
		/// <summary>Do generowania losowych pytań</summary>
		private static Random r = new Random( DateTime.Now.Millisecond );

		/// <summary>Tablica opcji odpowiedzi</summary>
		private int[] answers;

		/// <summary>Numer pytania</summary>
		public int QuestionNr { get; private set; }

		/// <summary>Treść pytania</summary>
		public string Question { get; private set; }

		public int UserAnswer { get; set; }
		public int GoodAnswer { get; private set; }

		/// <summary>Opcjonalne odpowiedzi</summary>

		public int AnswerA { get { return answers[0]; } set { answers[0] = value; } }
		public int AnswerB { get { return answers[1]; } set { answers[1] = value; } }
		public int AnswerC { get { return answers[2]; } set { answers[2] = value; } }

		public ABCModeQuestion( int questionNumber, string question, int goodAnswer, int opt2, int opt3 )
		{
			_ABCModeQuestionBase( questionNumber, question, goodAnswer, opt2, opt3 );
		}
		public ABCModeQuestion( int qNr, MulTabQuestion q )
		{
			_ABCModeQuestionBase( qNr, q.Question, q.Answer, q.LikelyAnswer(), q.LikelyAnswer() );
		}

		private void _ABCModeQuestionBase(int qNr, string question, int gAns, int opt2, int opt3)
		{
			QuestionNr = qNr;
			Question = question;
			GoodAnswer = gAns;

			answers = new int[3];
			answers[0] = GoodAnswer;
			answers[1] = opt2;
			answers[2] = opt3;
			// przemieszanie wartości
			answers = answers.OrderBy( ( item ) => r.Next() ).ToArray();
		}

		public bool CheckUserAnswer()
		{
			//return UserAnswer == GoodAnswer;
			return UserAnswer.Equals( GoodAnswer );
		}
	}
}
