﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows.Interactivity;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows.Media.Animation;

namespace MultipTabForKids.Behavior
{

	public class StartBtnBehavior : Behavior<Control>
	{
		protected static readonly LinearGradientBrush slashBrush = App.Current.FindResource( "sboardSlashGradientBrush" ) as LinearGradientBrush;
		protected static readonly Storyboard slashStoryboard = App.Current.FindResource( "sboardSlashGradientAnim" ) as Storyboard;
		protected Brush prevForegroundBrush;
		protected Brush prevBorderBrush;

		protected override void OnAttached()
		{
			prevForegroundBrush = AssociatedObject.Foreground;
			prevBorderBrush = AssociatedObject.BorderBrush;
			AssociatedObject.MouseEnter += AssociatedObject_MouseEnter;
			AssociatedObject.MouseLeave += AssociatedObject_MouseLeave;
		}

		private void AssociatedObject_MouseEnter( object sender, System.Windows.Input.MouseEventArgs e )
		{
			AssociatedObject.Foreground = slashBrush;
			AssociatedObject.BorderBrush = slashBrush;
			AssociatedObject.BeginStoryboard( slashStoryboard );
		}

		private void AssociatedObject_MouseLeave( object sender, System.Windows.Input.MouseEventArgs e )
		{
			AssociatedObject.BorderBrush = prevBorderBrush;
			AssociatedObject.Foreground = prevForegroundBrush;
		}

		protected override void OnDetaching()
		{
			AssociatedObject.MouseEnter -= AssociatedObject_MouseEnter;
			AssociatedObject.MouseLeave -= AssociatedObject_MouseLeave;
			AssociatedObject.Background = prevForegroundBrush;
		}
	}
}
