﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace ZadaniaWPF.ModelWidoku
{
    public class Zadanie : INotifyPropertyChanged
    {
        private Model.Zadanie model;

        public string Opis { get { return model.Opis; } }
        public DateTime DataUtworzenia { get { return model.DataUtworzenia; } }
        public DateTime PlanowanyTerminRealizacji { get { return model.PlanowanyTerminRealizacji; } }
        public Model.PriorytetZadania Priorytet { get { return model.Priorytet; } }
        public bool CzyZrealizowane { get { return model.CzyZrealizowane; } }

        public bool CzyNiezrealizowanePoTerminie
        {
            get
            {
                return !CzyZrealizowane && (DateTime.Now > PlanowanyTerminRealizacji);
            }
        }

        public Zadanie(Model.Zadanie model)
        {
            this.model = model;
        }

        public Zadanie(
            string opis, DateTime dataUtworzenia,
            DateTime planowanyTerminRealizacji, Model.PriorytetZadania prioryteZadania,
            bool czyZrealizowane = false)
        {
            model = new Model.Zadanie(
                opis, dataUtworzenia, planowanyTerminRealizacji, prioryteZadania, czyZrealizowane);
        }

        public Model.Zadanie GetModel()
        {
            return model;
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if(PropertyChanged!=null)
            {
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
            }
        }

        private ICommand oznaczJakoZrealizowane;

        public ICommand OznaczJakoZrealizowane
        {
            get
            {
                if (oznaczJakoZrealizowane == null)
                    oznaczJakoZrealizowane = new RelayCommand(
                        o =>
                        {
                            model.CzyZrealizowane = true;
                            OnPropertyChanged("CzyZrealizowane", "CzyNiezrealizowanePoTerminie");
                        },
                        o =>
                        {
                            return !model.CzyZrealizowane;
                        });
                return oznaczJakoZrealizowane;
            }
        }

        private ICommand oznaczJakoNiezrealizowane;

        public ICommand OznaczJakoNiezrealizowane
        {
            get
            {
                if (oznaczJakoNiezrealizowane == null)
                    oznaczJakoNiezrealizowane = new RelayCommand(
                        o =>
                        {
                            model.CzyZrealizowane = false;
                            OnPropertyChanged("CzyZrealizowane", "CzyNiezrealizowanePoTerminie");
                        },
                        o =>
                        {
                            return model.CzyZrealizowane;
                        });
                return oznaczJakoNiezrealizowane;
            }
        }
    }
}
