﻿using System;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.IO;
using System.Windows.Input;
using System.Windows;

namespace ZadaniaWPF.ModelWidoku
{
    class Zadania
    {
        private const string ścieżkaPlikuXml = "zadania.xml";

        private Model.Zadania model;
        public ObservableCollection<Zadanie> ListaZadań { get; } = new ObservableCollection<Zadanie>();

        private void KopiujZadaniaZModelu()
        {
            ListaZadań.CollectionChanged -= ListaZadań_CollectionChanged;
            ListaZadań.Clear();
            foreach (Model.Zadanie z in model)
            {
                ListaZadań.Add(new Zadanie(z));
            }
            ListaZadań.CollectionChanged += ListaZadań_CollectionChanged;
        }

        private void ListaZadań_CollectionChanged(object sender, NotifyCollectionChangedEventArgs e)
        {
            switch (e.Action)
            {
                case NotifyCollectionChangedAction.Add:
                    Zadanie noweZadanie = e.NewItems[0] as Zadanie;
                    model.DodajZadanie(noweZadanie.GetModel());
                    break;
                case NotifyCollectionChangedAction.Remove:
                    Zadanie usuwaneZadanie = e.OldItems[0] as Zadanie;
                    model.UsuńZadanie(usuwaneZadanie.GetModel());
                    break;
            }
        }

        public Zadania()
        {
            if (File.Exists(ścieżkaPlikuXml))
                model = Model.PlikXML.Czytaj(ścieżkaPlikuXml);
            else model = new Model.Zadania();

            //*
            if (model.LiczbaZadań == 0)
            {
                model.DodajZadanie(
                    new Model.Zadanie(
                        "Pierwsze",
                        DateTime.Now,
                        DateTime.Now.AddDays(1),
                        Model.PriorytetZadania.MniejWażne));
                model.DodajZadanie(
                    new Model.Zadanie(
                        "Drugie",
                        DateTime.Now,
                        DateTime.Now.AddDays(3),
                        Model.PriorytetZadania.Krytyczne));
                model.DodajZadanie(
                    new Model.Zadanie(
                        "Trzecie",
                        DateTime.Now,
                        DateTime.Now.AddDays(10),
                        Model.PriorytetZadania.Ważne));
            }
            //*/

            KopiujZadaniaZModelu();
        }

        private ICommand zapiszCommand;

        public ICommand Zapisz
        {
            get
            {
                if (zapiszCommand == null)
                    zapiszCommand = new RelayCommand(
                        argument =>
                        {
                            Model.PlikXML.Zapisz(ścieżkaPlikuXml, model);
                        });
                return zapiszCommand;
            }
        }

        private ICommand usuńZadanieCommand;

        public ICommand UsuńZadanie
        {
            get
            {
                if (usuńZadanieCommand == null)
                    usuńZadanieCommand = new RelayCommand(
                        o =>
                        {
                            int indeksZadania = (int)o;
                            Zadanie zadanie = ListaZadań[indeksZadania];
                            if (!zadanie.CzyZrealizowane)
                            {
                                MessageBoxResult wynik = MessageBox.Show("Czy jesteś pewien, że chcesz usunąć niezrealizowane zadanie?", "Zadania WPF", MessageBoxButton.YesNo, MessageBoxImage.Question, MessageBoxResult.No);
                                if (wynik == MessageBoxResult.No) return;
                            }
                            ListaZadań.RemoveAt(indeksZadania);
                        },
                        o =>
                        {
                            if (o == null) return false;
                            int indeksZadania = (int)o;
                            return indeksZadania >= 0;
                        });
                return usuńZadanieCommand;
            }
        }

        private ICommand dodajZadanieCommand;
        
        public ICommand DodajZadanie
        {
            get
            {
                if (dodajZadanieCommand == null)
                    dodajZadanieCommand = new RelayCommand(
                        o =>
                        {
                            Zadanie noweZadanie = o as Zadanie;
                            ListaZadań.Add(noweZadanie);
                        },
                        o =>
                        {
                            return (o as Zadanie) != null;
                        });
                return dodajZadanieCommand;
            }
        }   
    }
}
