﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace ZadaniaWPF.Model
{
    public static class PlikXML
    {
        public static void Zapisz(string ścieżkaPliku, Zadania model)
        {
            try
            {
                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XComment("Data utworzenia pliku: " + DateTime.Now.ToString()),
                    new XElement("Zadania",
                        from Zadanie z in model
                        select new XElement("Zadanie",
                            new XElement("Opis", z.Opis),
                            new XElement("DataUtworzenia", z.DataUtworzenia.ToString()),
                            new XElement("PlanowanyTerminRealizacji", z.PlanowanyTerminRealizacji.ToString()),
                            new XElement("Priorytet", (byte)z.Priorytet),
                            new XElement("CzyZrealizowane", z.CzyZrealizowane.ToString()))));
                xml.Save(ścieżkaPliku);               
            }
            catch(Exception exc)
            {
                throw new Exception("Błąd przy zapisie danych do pliku XML", exc);
            }
        }

        public static Zadania Czytaj(string ścieżkaPliku)
        {
            try
            {
                XDocument xml = XDocument.Load(ścieżkaPliku);
                IEnumerable<Zadanie> dane =
                    from zadanie in xml.Root.Descendants("Zadanie")
                    select new Zadanie(
                        zadanie.Element("Opis").Value,
                        DateTime.Parse(zadanie.Element("DataUtworzenia").Value),
                        DateTime.Parse(zadanie.Element("PlanowanyTerminRealizacji").Value),
                        (PriorytetZadania)byte.Parse(zadanie.Element("Priorytet").Value),
                        bool.Parse(zadanie.Element("CzyZrealizowane").Value));
                Zadania model = new Zadania();
                foreach (Zadanie z in dane) model.DodajZadanie(z);
                return model;
            }
            catch (Exception exc)
            {
                throw new Exception("Błąd przy odczycie danych z pliku XML", exc);
            }
        }
    }
}

