﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;

namespace ZadaniaWPF
{
    public class TwórzZadanie : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            string opis = (string)values[0];
            DateTime terminUtworzenia = DateTime.Now;
            DateTime? planowanyTerminRealizacji = (DateTime?)values[1];
            Model.PriorytetZadania priorytet = (Model.PriorytetZadania)(int)values[2];
            if (!string.IsNullOrWhiteSpace(opis) && planowanyTerminRealizacji.HasValue)
                return new ModelWidoku.Zadanie(opis, terminUtworzenia, planowanyTerminRealizacji.Value, priorytet, false);
            else return null;
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
