﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZadaniaWPF.ModelWidoku
{
    class Zadania
    {
        private const string ścieżkaPlikuXml = "zadania.xml";

        private Model.Zadania model;
        public ObservableCollection<Zadanie> ListaZadań { get; } = new ObservableCollection<Zadanie>();

        private void KopiujZadaniaZModelu()
        {
            ListaZadań.CollectionChanged -= ListaZadań_CollectionChanged;
            ListaZadań.Clear();
            foreach(Model.Zadanie z in model)
            {
                ListaZadań.Add(new Zadanie(z));
            }
            ListaZadań.CollectionChanged += ListaZadań_CollectionChanged;
        }

        private void ListaZadań_CollectionChanged(object sender, NotifyCollectionChangedEventArgs e)
        {
            switch (e.Action)
            {
                case NotifyCollectionChangedAction.Add:
                    Zadanie noweZadanie = e.NewItems[0] as Zadanie;
                    model.DodajZadanie(noweZadanie.GetModel());
                    break;
                case NotifyCollectionChangedAction.Remove:
                    Zadanie usuwaneZadanie = e.OldItems[0] as Zadanie;
                    model.UsuńZadanie(usuwaneZadanie.GetModel());
                    break;
            }
        }

        public Zadania()
        {
            if (File.Exists(ścieżkaPlikuXml))
                model = Model.PlikXML.Czytaj(ścieżkaPlikuXml);
            else model = new Model.Zadania();

            if(model.LiczbaZadań == 0)
            {
                model.DodajZadanie(
                    new Model.Zadanie(
                        "Pierwsze",
                        DateTime.Now,
                        DateTime.Now.AddDays(1),
                        Model.PriorytetZadania.MniejWażne));
                model.DodajZadanie(
                    new Model.Zadanie(
                        "Drugie",
                        DateTime.Now,
                        DateTime.Now.AddDays(3),
                        Model.PriorytetZadania.Krytyczne));
                model.DodajZadanie(
                    new Model.Zadanie(
                        "Trzecie",
                        DateTime.Now,
                        DateTime.Now.AddDays(10),
                        Model.PriorytetZadania.Ważne));
            }

            KopiujZadaniaZModelu();
        }
    }
}
