﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZadaniaWPF.Model
{
    public enum PriorytetZadania : byte { MniejWażne, Ważne, Krytyczne };

    public class Zadanie
    {
        public string Opis { get; private set; }
        public DateTime DataUtworzenia { get; private set; }
        public DateTime PlanowanyTerminRealizacji { get; private set; }
        public PriorytetZadania Priorytet { get; private set; }
        public bool CzyZrealizowane { get; set; }

        public Zadanie(string opis, DateTime dataUtworzenia, 
            DateTime planowanyTerminRealizacji, PriorytetZadania prioryteZadania,
            bool czyZrealizowane = false)
        {
            this.Opis = opis;
            this.DataUtworzenia = dataUtworzenia;
            this.PlanowanyTerminRealizacji = planowanyTerminRealizacji;
            this.Priorytet = prioryteZadania;
            this.CzyZrealizowane = czyZrealizowane;
        }

        public override string ToString()
        {
            return Opis + " " + PlanowanyTerminRealizacji.ToLongDateString() + " " + Priorytet.ToString();
        }
    }
}
