﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;
using System.Windows.Media;

namespace AsystentZakupówWPF
{
    public class BoolToBrushConverter : IValueConverter
    {
        //public Brush BrushTrue { get; set; } = Brushes.Green;
        //public Brush BrushFalse { get; set; } = Brushes.Red;

        public Brush BrushTrue { get; set; }
        public Brush BrushFalse { get; set; }

        public BoolToBrushConverter()
        {
            BrushTrue = Brushes.Green;
            BrushFalse = Brushes.Red;
        }

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            bool b = (bool)value;
            return b ? BrushTrue : BrushFalse;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
