﻿using System.Windows.Media;
using System.ComponentModel;

namespace KoloryWPF.ModelWidoku
{
    using Model;
    using System.Windows.Input;
    using System;    

    public class EdycjaKoloru : INotifyPropertyChanged
    {
        Kolor kolor = Ustawienia.Czytaj();

        public byte R
        {
            get
            {
                return kolor.R;
            }
            set
            {
                kolor.R = value;
                OnPropertyChanged("R", "Color");
            }
        }

        public byte G
        {
            get
            {
                return kolor.G;
            }
            set
            {
                kolor.G = value;
                OnPropertyChanged("G", "Color");                
            }
        }

        public byte B
        {
            get
            {
                return kolor.B;
            }
            set
            {
                kolor.B = value;
                OnPropertyChanged("B", "Color");                
            }
        }

        /*
        public Color Color
        {
            get
            {
                return kolor.ToColor();
            }
        }
        */

        public void Zapisz()
        {
            Ustawienia.Zapisz(kolor);
        }

        public event PropertyChangedEventHandler PropertyChanged;

        /*
        private void OnPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null) 
                PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }
        */

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if (PropertyChanged != null)
                foreach(string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }

        private ICommand resetujCommand;

        public ICommand Resetuj
        {
            get
            {
                if (resetujCommand == null)
                    resetujCommand = new RelayCommand(
                        arg => { R = 0; G = 0; B = 0; },
                        arg => R != 0 || G != 0 || B != 0 );
                return resetujCommand;
            }
        }
    }

    /*
    public class ResetujCommand : ICommand
    {
        private EdycjaKoloru modelWidoku;

        public ResetujCommand(EdycjaKoloru modelWidoku)
        {
            this.modelWidoku = modelWidoku;
            if (modelWidoku == null) throw new ArgumentNullException("modelWidoku");
        }

        public bool CanExecute(object parameter)
        {
            return
                modelWidoku.R != 0 ||
                modelWidoku.G != 0 ||
                modelWidoku.B != 0;
        }

        public event System.EventHandler CanExecuteChanged
        {
            add
            {
                CommandManager.RequerySuggested += value;
            }
            remove
            {
                CommandManager.RequerySuggested -= value;
            }
        }

        public void Execute(object parameter)
        {
            modelWidoku.R = 0;
            modelWidoku.G = 0;
            modelWidoku.B = 0;
        }
    }
    */

    static class Rozszerzenia
    {
        public static Color ToColor(this Kolor kolor)
        {
            return Color.FromRgb(kolor.R, kolor.G, kolor.B);
        }
    }
}
