﻿using System.ComponentModel;
using System.Windows.Media;

namespace KoloryWPF.ModelWidoku
{
    using Model;    

    public class EdycjaKoloru2 : INotifyPropertyChanged
    {
        //public byte R { get; set; }
        //public byte G { get; set; }
        //public byte B { get; set; }

        private byte r, g, b;

        public byte R
        {
            get
            {
                return r;
            }
            set
            {
                r = value;
                OnPropertyChanged("R", "Color");
            }
        }

        public byte G
        {
            get
            {
                return g;
            }
            set
            {
                g = value;
                OnPropertyChanged("G", "Color");
            }
        }

        public byte B
        {
            get
            {
                return b;
            }
            set
            {
                b = value;
                OnPropertyChanged("B", "Color");
            }
        }

        public EdycjaKoloru2()
        {
            Kolor kolor = Ustawienia.Czytaj();
            R = kolor.R;
            G = kolor.G;
            B = kolor.B;
        }

        public Color Color
        {
            get
            {
                return Color.FromRgb(R, G, B);
            }
        }

        public void Zapisz()
        {
            Ustawienia.Zapisz(new Kolor(R, G, B));
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if (PropertyChanged != null)
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }
    }
}
