﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

//code-behind
//AV = wzorzec autonomicznego widoku
namespace KoloryWPF
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();

            Color kolor = Ustawienia.Czytaj();
            rectangle.Fill = new SolidColorBrush(kolor);
            sliderR.Value = kolor.R;
            sliderG.Value = kolor.G;
            sliderB.Value = kolor.B;
        }

        private Color kolorProstokąta
        {
            get
            {
                return (rectangle.Fill as SolidColorBrush).Color;
            }
            set
            {                
                (rectangle.Fill as SolidColorBrush).Color = value;
            }
        }

        private void slider_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            byte r = (byte)sliderR.Value;
            byte g = (byte)sliderG.Value;
            byte b = (byte)sliderB.Value;
            //rectangle.Fill = new SolidColorBrush(Color.FromRgb(r,g,b));
            kolorProstokąta = Color.FromRgb(r, g, b);            
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            Ustawienia.Zapisz(kolorProstokąta);
        }
    }
}
