﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZadaniaWPF.Model
{
    public enum PriorytetZadania : Byte { MniejWażne, Ważne, Krytyczne };

    public class Zadanie
    {
        public string Opis { get; private set; }
        public DateTime DataUtworzenia { get; private set; }
        public DateTime PlanowanyTerminRealizacji { get; private set; }
        public PriorytetZadania Priorytet { get; private set; }
        public bool CzyZrealizowane { get; set; }

        public Zadanie(string opis, DateTime dataUtworzenia,
                       DateTime planowanyTerminRealizacji, PriorytetZadania priorytet,
                       bool czyZrealizowane)
        {
            this.Opis = opis;
            this.DataUtworzenia = dataUtworzenia;
            this.PlanowanyTerminRealizacji = planowanyTerminRealizacji;
            this.Priorytet = priorytet;
            this.CzyZrealizowane = czyZrealizowane;
        }

        /*
        public override string ToString()
        {
            return opis;
        }
        */

        public static string OpisPriorytetu(PriorytetZadania priorytet)
        {
            switch (priorytet)
            {
                case PriorytetZadania.MniejWażne:
                    return "mniej ważne";
                case PriorytetZadania.Ważne:
                    return "ważne";
                case PriorytetZadania.Krytyczne:
                    return "krytyczne";
                default:
                    throw new Exception("Nierozpoznany priorytet zadania");
            }
        }

        public static PriorytetZadania ParsujOpisPriorytetu(string opis)
        {
            switch (opis)
            {
                case "mniej ważne":
                    return PriorytetZadania.MniejWażne;
                case "ważne":
                    return PriorytetZadania.Ważne;
                case "krytyczne":
                    return PriorytetZadania.Krytyczne;
                default:
                    throw new Exception("Nierozpoznany opis priorytetu zadania");
            }
        }
    }
}
