﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;
using System.Windows.Media;

namespace ZadaniaWPF
{
    public class BoolToBrushConverter : IValueConverter
    {
        public Brush KolorDlaFałszu { get; set; } = Brushes.Black;
        public Brush KolorDlaPrawdy { get; set; } = Brushes.Gray;

        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            bool bvalue = (bool)value;
            return bvalue ? KolorDlaPrawdy : KolorDlaFałszu;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }

    public class PriorytetZadanieToStringConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            Model.PriorytetZadania priorytetZadania = (Model.PriorytetZadania)value;
            return Model.Zadanie.OpisPriorytetu(priorytetZadania);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string opisPriorytetu = (value as string).ToLower();
            return Model.Zadanie.ParsujOpisPriorytetu(opisPriorytetu);
        }
    }

    public class PriorytetZadaniaToBrushConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            Model.PriorytetZadania priorytet = (Model.PriorytetZadania)value;
            switch(priorytet)
            {
                case Model.PriorytetZadania.Krytyczne:
                    return Brushes.OrangeRed;
                case Model.PriorytetZadania.Ważne:
                    return Brushes.Orange;
                case Model.PriorytetZadania.MniejWażne:
                    return Brushes.Olive;
                default:
                    throw new Exception("Nierozpoznany typ zadania");
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }

    public class BoolToTextDecorationConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            bool bvalue = (bool)value;
            return bvalue ? TextDecorations.Strikethrough : null;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
