﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZadaniaWPF.ModelWidoku
{
    public class Zadania
    {

        private const string ścieżkaPlikuXml = "zadania.xml";

        //przechowywanie dwóch kolekcji
        private Model.Zadania model;
        public ObservableCollection<Zadanie> ListaZadań { get; } = new ObservableCollection<Zadanie>();

        private void KopiujZadaniaZModelu()
        {
            //ListaZadań.CollectionChanged -= SynchronizacjaModelu;
            ListaZadań.Clear();
            foreach (Model.Zadanie zadanie in model) ListaZadań.Add(new Zadanie(zadanie));
            //ListaZadań.CollectionChanged += SynchronizacjaModelu;
        }

        public Zadania()
        {
            if (System.IO.File.Exists(ścieżkaPlikuXml))
            {
                model = Model.PlikXml.Czytaj(ścieżkaPlikuXml);
            }
            else model = new Model.Zadania();

            //testy - początek
            if (model.LiczbaZadań == 0)
            {
                model.DodajZadanie(
                    new Model.Zadanie("Pierwsze", DateTime.Now,
                        DateTime.Now.AddDays(2), Model.PriorytetZadania.MniejWażne, false));
                model.DodajZadanie(
                    new Model.Zadanie("Drugie", DateTime.Now,
                        DateTime.Now.AddDays(1), Model.PriorytetZadania.Krytyczne, false));
                model.DodajZadanie(
                    new Model.Zadanie("Trzecie", DateTime.Now,
                        DateTime.Now.AddDays(3), Model.PriorytetZadania.Ważne, false));
            }
            //testy - koniec            

            KopiujZadaniaZModelu();
        }

        Synchronizacja
    }
}
