﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace ZadaniaWPF.Model
{
    public static class PlikXml
    {
        private const string nazwaElementuOpisu = "Opis";

        public static void Zapisz(string ścieżkaPliku, Zadania zadania)
        {
            try
            {
                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XComment("Data zapisania: " + DateTime.Now.ToString()),
                    new XElement("Zadania",
                        from Zadanie zadanie in zadania
                        select new XElement("Zadanie",
                            new XElement(nazwaElementuOpisu, zadanie.Opis),
                            new XElement("DataUtworzenia", zadanie.DataUtworzenia),
                            new XElement("PlanowanyTerminRealizacji", zadanie.PlanowanyTerminRealizacji),
                            new XElement("Priorytet", Zadanie.OpisPriorytetu(zadanie.Priorytet)),
                            new XElement("CzyZrealizowane", zadanie.CzyZrealizowane))));
                xml.Save(ścieżkaPliku);
            }
            catch(Exception exc)
            {
                throw new Exception("Błąd przy zapisie danych do pliku XML", exc);
            }
        }

        public static Zadania Czytaj(string ścieżkaPliku)
        {
            try
            {
                XDocument xml = XDocument.Load(ścieżkaPliku);
                IEnumerable<Zadanie> dane =
                    from XElement zadanie in xml.Root.Descendants("Zadanie")
                    select new Zadanie(
                        zadanie.Element(nazwaElementuOpisu).Value,
                        DateTime.Parse(zadanie.Element("DataUtworzenia").Value),
                        DateTime.Parse(zadanie.Element("PlanowanyTerminRealizacji").Value),
                        Zadanie.ParsujOpisPriorytetu(zadanie.Element("Priorytet").Value),
                        bool.Parse(zadanie.Element("CzyZrealizowane").Value));
                Zadania zadania = new Zadania();
                foreach (Zadanie zadanie in dane) zadania.DodajZadanie(zadanie);
                return zadania;
            }
            catch (Exception exc)
            {
                throw new Exception("Błąd przy odczycie danych z pliku XML", exc);
            }
        }
    }
}
